/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedList<E> {
    transient int size = 0;
    transient ENTRY<E> first;
    transient ENTRY<E> last;

    public void addFirst(E e) {
        ENTRY<E> f = this.first;
        ENTRY<E> newNode = new ENTRY<E>(null, e, f);
        this.first = newNode;
        if (f == null) {
            this.last = newNode;
        } else {
            f.prev = newNode;
        }
        ++this.size;
    }

    public void addLast(E e) {
        ENTRY<E> l = this.last;
        ENTRY<E> newNode = new ENTRY<E>(l, e, null);
        this.last = newNode;
        if (l == null) {
            this.first = newNode;
        } else {
            l.next = newNode;
        }
        ++this.size;
    }

    public ENTRY<E> putBefore(E e, ENTRY<E> succ) {
        ENTRY pred = succ.prev;
        ENTRY newNode = new ENTRY(pred, e, succ);
        succ.prev = newNode;
        if (pred == null) {
            this.first = newNode;
        } else {
            pred.next = newNode;
        }
        ++this.size;
        return newNode;
    }

    public E remove(ENTRY<E> x) {
        Object element = x.item;
        ENTRY next = x.next;
        ENTRY prev = x.prev;
        if (prev == null) {
            this.first = next;
        } else {
            prev.next = next;
        }
        if (next == null) {
            this.last = prev;
        } else {
            next.prev = prev;
        }
        --this.size;
        return element;
    }

    public ENTRY<E> getFirst() {
        return this.first;
    }

    public ENTRY<E> getLast() {
        return this.last;
    }

    public ENTRY<E> getNext(ENTRY<E> o) {
        return o.next;
    }

    public E removeFirst() {
        ENTRY<E> f = this.first;
        if (f != null) {
            return this.remove(this.first);
        }
        return null;
    }

    public E removeLast() {
        ENTRY<E> l = this.last;
        if (l != null) {
            return this.remove(l);
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    public void clear() {
        ENTRY<E> x = this.first;
        while (x != null) {
            ENTRY next = x.next;
            x.item = null;
            x.next = null;
            x.prev = null;
            x = next;
        }
        this.last = null;
        this.first = null;
        this.size = 0;
    }

    public E[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        ENTRY<E> x = this.first;
        while (x != null) {
            result[i++] = x.item;
            x = x.next;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ENTRY<E> {
        public E item;
        public ENTRY<E> next;
        public ENTRY<E> prev;

        ENTRY(ENTRY<E> prev, E element, ENTRY<E> next) {
            this.item = element;
            this.next = next;
            this.prev = prev;
        }
    }
}

