/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import scouter.util.CompareUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedSet<V> {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private LinkedSetry<V>[] table;
    private LinkedSetry<V> header;
    private int count;
    private int threshold;
    private float loadFactor;
    private int max;

    public LinkedSet(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new LinkedSetry[initCapacity];
        this.header = new LinkedSetry<Object>(null, null);
        this.header.link_prev = this.header;
        this.header.link_next = this.header.link_prev;
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public LinkedSet() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public V[] getArray() {
        Object[] _keys = new Object[this.size()];
        Enumeration<V> en = this.elements();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextElement();
        }
        return _keys;
    }

    public synchronized Enumeration<V> elements() {
        return new Enumer();
    }

    public synchronized boolean contains(V key) {
        if (key == null) {
            return false;
        }
        LinkedSetry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LinkedSetry<V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized V getFirst() {
        return this.header.link_next.key;
    }

    public synchronized V getLast() {
        return this.header.link_prev.key;
    }

    private int hash(V key) {
        return key.hashCode() & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        LinkedSetry<V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        LinkedSetry[] newMap = new LinkedSetry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            LinkedSetry<V> old = oldMap[i];
            while (old != null) {
                LinkedSetry<V> e = old;
                old = old.next;
                Object key = e.key;
                int index = this.hash(key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public LinkedSet<V> setMax(int max) {
        this.max = max;
        return this;
    }

    public V put(V key) {
        return this._put(key, MODE.LAST);
    }

    public V putLast(V key) {
        return this._put(key, MODE.FORCE_LAST);
    }

    public V putFirst(V key) {
        return this._put(key, MODE.FORCE_FIRST);
    }

    private synchronized V _put(V key, MODE m) {
        if (key == null) {
            return null;
        }
        LinkedSetry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LinkedSetry<V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                switch (m) {
                    case FORCE_FIRST: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case FORCE_LAST: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return e.key;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case FORCE_FIRST: 
                case FIRST: {
                    Object v;
                    while (this.count >= this.max) {
                        v = this.header.link_prev.key;
                        this.remove(v);
                        this.overflowed(v);
                    }
                    break;
                }
                case FORCE_LAST: 
                case LAST: {
                    Object v;
                    while (this.count >= this.max) {
                        v = this.header.link_next.key;
                        this.remove(v);
                        this.overflowed(v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new LinkedSetry<V>(key, tab[index]);
        switch (m) {
            case FORCE_FIRST: 
            case FIRST: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case FORCE_LAST: 
            case LAST: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return key;
    }

    protected void overflowed(V value) {
    }

    public synchronized boolean remove(V key) {
        if (key == null) {
            return false;
        }
        LinkedSetry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LinkedSetry<V> e = tab[index];
        LinkedSetry<V> prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                this.unchain(e);
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }

    public synchronized boolean removeFirst() {
        if (this.isEmpty()) {
            return false;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized boolean removeLast() {
        if (this.isEmpty()) {
            return false;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void clear() {
        LinkedSetry<V>[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_prev = this.header;
        this.header.link_next = this.header.link_prev;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<V> it = this.elements();
        buf.append("{");
        while (it.hasMoreElements()) {
            if (buf.length() > 1) {
                buf.append(",");
            }
            buf.append(it.nextElement());
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(LinkedSetry link_prev, LinkedSetry link_next, LinkedSetry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(LinkedSetry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedSetry<V> {
        V key;
        LinkedSetry<V> next;
        LinkedSetry<V> link_next;
        LinkedSetry<V> link_prev;

        protected LinkedSetry(V key, LinkedSetry<V> next) {
            this.key = key;
            this.next = next;
        }

        protected Object clone() {
            return new LinkedSetry<V>(this.key, this.next == null ? null : (LinkedSetry)this.next.clone());
        }

        public V getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LinkedSetry)) {
                return false;
            }
            LinkedSetry e = (LinkedSetry)o;
            return CompareUtil.equals(e.key, this.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return this.key.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Enumer<V>
    implements Enumeration<V> {
        LinkedSetry<V> entry;

        private Enumer() {
            this.entry = ((LinkedSet)LinkedSet.this).header.link_next;
        }

        @Override
        public boolean hasMoreElements() {
            return LinkedSet.this.header != this.entry && this.entry != null;
        }

        @Override
        public V nextElement() {
            if (this.hasMoreElements()) {
                LinkedSetry<V> e = this.entry;
                this.entry = e.link_next;
                return e.key;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MODE {
        FORCE_FIRST,
        FORCE_LAST,
        FIRST,
        LAST;

    }
}

