/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import scouter.util.CompareUtil;
import scouter.util.LongEnumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongKeyLinkedMap<V> {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private LongKeyLinkedEntry<V>[] table;
    private LongKeyLinkedEntry<V> header;
    private int count;
    private int threshold;
    private float loadFactor;
    private int max;

    public LongKeyLinkedMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new LongKeyLinkedEntry[initCapacity];
        this.header = new LongKeyLinkedEntry<Object>(0L, null, null);
        this.header.link_prev = this.header;
        this.header.link_next = this.header.link_prev;
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public LongKeyLinkedMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public long[] keyArray() {
        long[] _keys = new long[this.size()];
        LongEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextLong();
        }
        return _keys;
    }

    public synchronized LongEnumer keys() {
        return new Enumer(TYPE.KEYS);
    }

    public synchronized Enumeration<V> values() {
        return new Enumer(TYPE.VALUES);
    }

    public synchronized Enumeration<LongKeyLinkedEntry<V>> entries() {
        return new Enumer(TYPE.ENTRIES);
    }

    public synchronized boolean containsValue(Object value) {
        if (value == null || this.size() == 0) {
            return false;
        }
        LongKeyLinkedEntry<V>[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            LongKeyLinkedEntry<V> e = tab[i];
            while (e != null) {
                if (CompareUtil.equals(e.value, value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(long key) {
        if (this.size() == 0) {
            return false;
        }
        LongKeyLinkedEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongKeyLinkedEntry<V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized V get(long key) {
        if (this.size() == 0) {
            return null;
        }
        LongKeyLinkedEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongKeyLinkedEntry<V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public V intern(long key) {
        return this._intern(key, MODE.LAST);
    }

    private synchronized V _intern(long key, MODE m) {
        LongKeyLinkedEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongKeyLinkedEntry<V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.next;
        }
        V value = this.create(key);
        if (value == null) {
            return null;
        }
        if (this.max > 0) {
            switch (m) {
                case FORCE_FIRST: 
                case FIRST: {
                    long k;
                    while (this.count >= this.max) {
                        k = this.header.link_prev.key;
                        V v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case FORCE_LAST: 
                case LAST: {
                    long k;
                    while (this.count >= this.max) {
                        k = this.header.link_next.key;
                        V v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        LongKeyLinkedEntry<V> e2 = new LongKeyLinkedEntry<V>(key, value, tab[index]);
        tab[index] = e2;
        switch (m) {
            case FORCE_FIRST: 
            case FIRST: {
                this.chain(this.header, this.header.link_next, e2);
                break;
            }
            case FORCE_LAST: 
            case LAST: {
                this.chain(this.header.link_prev, this.header, e2);
            }
        }
        ++this.count;
        return value;
    }

    protected void overflowed(long key, V value) {
    }

    protected V create(long key) {
        throw new RuntimeException("not implemented create()");
    }

    public synchronized long getFirstKey() {
        if (this.size() == 0) {
            return 0L;
        }
        return this.header.link_next.key;
    }

    public synchronized long getLastKey() {
        if (this.size() == 0) {
            return 0L;
        }
        return this.header.link_prev.key;
    }

    public synchronized V getFirstValue() {
        if (this.size() == 0) {
            return null;
        }
        return this.header.link_next.value;
    }

    public synchronized V getLastValue() {
        if (this.size() == 0) {
            return null;
        }
        return this.header.link_prev.value;
    }

    private int hash(long key) {
        return (int)(key ^ key >>> 32) & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        LongKeyLinkedEntry<V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        LongKeyLinkedEntry[] newMap = new LongKeyLinkedEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            LongKeyLinkedEntry<V> old = oldMap[i];
            while (old != null) {
                LongKeyLinkedEntry<V> e = old;
                old = old.next;
                long key = e.key;
                int index = this.hash(key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public LongKeyLinkedMap<V> setMax(int max) {
        this.max = max;
        return this;
    }

    public V put(long key, V value) {
        return this._put(key, value, MODE.LAST);
    }

    public V putLast(long key, V value) {
        return this._put(key, value, MODE.FORCE_LAST);
    }

    public V putFirst(long key, V value) {
        return this._put(key, value, MODE.FORCE_FIRST);
    }

    private synchronized V _put(long key, V value, MODE m) {
        LongKeyLinkedEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongKeyLinkedEntry<V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                Object old = e.value;
                e.value = value;
                switch (m) {
                    case FORCE_FIRST: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case FORCE_LAST: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case FORCE_FIRST: 
                case FIRST: {
                    while (this.count >= this.max) {
                        long k = this.header.link_prev.key;
                        V v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case FORCE_LAST: 
                case LAST: {
                    while (this.count >= this.max) {
                        long k = this.header.link_next.key;
                        V v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new LongKeyLinkedEntry<V>(key, value, tab[index]);
        switch (m) {
            case FORCE_FIRST: 
            case FIRST: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case FORCE_LAST: 
            case LAST: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return null;
    }

    public synchronized V remove(long key) {
        LongKeyLinkedEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongKeyLinkedEntry<V> e = tab[index];
        LongKeyLinkedEntry<V> prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                this.unchain(e);
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized V removeFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized V removeLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void clear() {
        LongKeyLinkedEntry<V>[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_prev = this.header;
        this.header.link_next = this.header.link_prev;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<LongKeyLinkedEntry<V>> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            LongKeyLinkedEntry<V> e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<LongKeyLinkedEntry<V>> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            LongKeyLinkedEntry<V> e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(LongKeyLinkedEntry link_prev, LongKeyLinkedEntry link_next, LongKeyLinkedEntry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(LongKeyLinkedEntry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public static void main(String[] args) {
        LongKeyLinkedMap<Integer> m = new LongKeyLinkedMap().setMax(2);
        m.putLast(10L, 10);
        m.putLast(20L, 20);
        m.putFirst(30L, 30);
        System.out.println(m);
        m = new LongKeyLinkedMap().setMax(2);
        m.putFirst(10L, 10);
        m.putFirst(20L, 20);
        m.putFirst(30L, 30);
        System.out.println(m);
    }

    private static void print(Object e) {
        System.out.println(e);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongKeyLinkedEntry<V> {
        long key;
        V value;
        LongKeyLinkedEntry<V> next;
        LongKeyLinkedEntry<V> link_next;
        LongKeyLinkedEntry<V> link_prev;

        protected LongKeyLinkedEntry(long key, V value, LongKeyLinkedEntry<V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new LongKeyLinkedEntry<V>(this.key, this.value, this.next == null ? null : (LongKeyLinkedEntry)this.next.clone());
        }

        public long getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LongKeyLinkedEntry)) {
                return false;
            }
            LongKeyLinkedEntry e = (LongKeyLinkedEntry)o;
            return CompareUtil.equals(e.key, this.key) && CompareUtil.equals(e.value, this.value);
        }

        public int hashCode() {
            return (int)(this.key ^ this.key >>> 32) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Enumer<V>
    implements Enumeration,
    LongEnumer {
        TYPE type;
        LongKeyLinkedEntry entry;

        Enumer(TYPE type) {
            this.entry = ((LongKeyLinkedMap)LongKeyLinkedMap.this).header.link_next;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            return LongKeyLinkedMap.this.header != this.entry;
        }

        public V nextElement() {
            if (this.entry != null) {
                LongKeyLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case KEYS: {
                        return (V)new Long(e.key);
                    }
                    case VALUES: {
                        return e.value;
                    }
                }
                return (V)e;
            }
            throw new NoSuchElementException("Enumerator");
        }

        @Override
        public long nextLong() {
            if (this.entry != null) {
                LongKeyLinkedEntry e = this.entry;
                this.entry = e.link_next;
                return e.key;
            }
            throw new NoSuchElementException("Enumer");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TYPE {
        KEYS,
        VALUES,
        ENTRIES;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MODE {
        FORCE_FIRST,
        FORCE_LAST,
        FIRST,
        LAST;

    }
}

