/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import scouter.util.CompareUtil;
import scouter.util.LongEnumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongKeyMap<V> {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private LongKeyEntry<V>[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    public LongKeyMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new LongKeyEntry[initCapacity];
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public LongKeyMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public synchronized long[] keyArray() {
        long[] _keys = new long[this.size()];
        LongEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextLong();
        }
        return _keys;
    }

    public synchronized LongEnumer keys() {
        return new Enumer(TYPE.KEYS);
    }

    public synchronized Enumeration<V> values() {
        return new Enumer(TYPE.VALUES);
    }

    public synchronized Enumeration<LongKeyEntry<V>> entries() {
        return new Enumer(TYPE.ENTRIES);
    }

    public synchronized boolean containsValue(V value) {
        if (value == null) {
            return false;
        }
        LongKeyEntry<V>[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            LongKeyEntry<V> e = tab[i];
            while (e != null) {
                if (CompareUtil.equals(e.value, value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(long key) {
        LongKeyEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongKeyEntry<V> e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized V get(long key) {
        LongKeyEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongKeyEntry<V> e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    private int hash(long key) {
        return (int)(key ^ key >>> 32) & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        LongKeyEntry<V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        LongKeyEntry[] newMap = new LongKeyEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            LongKeyEntry<V> old = oldMap[i];
            while (old != null) {
                LongKeyEntry<V> e = old;
                old = old.next;
                long key = e.key;
                int index = this.hash(key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public synchronized V put(long key, V value) {
        LongKeyEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongKeyEntry<V> e = tab[index];
        while (e != null) {
            if (e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new LongKeyEntry<V>(key, value, tab[index]);
        ++this.count;
        return null;
    }

    public synchronized Object remove(long key) {
        LongKeyEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongKeyEntry<V> e = tab[index];
        LongKeyEntry<V> prev = null;
        while (e != null) {
            if (e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized void clear() {
        LongKeyEntry<V>[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<LongKeyEntry<V>> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            LongKeyEntry<V> e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<LongKeyEntry<V>> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            LongKeyEntry<V> e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongKeyEntry<V> {
        long key;
        V value;
        LongKeyEntry<V> next;

        protected LongKeyEntry(long key, V value, LongKeyEntry<V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new LongKeyEntry<V>(this.key, this.value, this.next == null ? null : (LongKeyEntry)this.next.clone());
        }

        public long getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LongKeyEntry)) {
                return false;
            }
            LongKeyEntry e = (LongKeyEntry)o;
            return CompareUtil.equals(e.key, this.key) && CompareUtil.equals(e.value, this.value);
        }

        public int hashCode() {
            return (int)(this.key ^ this.key >>> 32) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value.toString();
        }
    }

    private class Enumer
    implements Enumeration,
    LongEnumer {
        LongKeyEntry[] table;
        int index;
        LongKeyEntry entry;
        LongKeyEntry lastReturned;
        TYPE type;

        Enumer(TYPE type) {
            this.table = LongKeyMap.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.type = type;
        }

        public boolean hasMoreElements() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            return this.entry != null;
        }

        public Object nextElement() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                LongKeyEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                switch (this.type) {
                    case KEYS: {
                        return e.key;
                    }
                    case VALUES: {
                        return e.value;
                    }
                }
                return e;
            }
            throw new NoSuchElementException("no more next");
        }

        public long nextLong() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                LongKeyEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                return e.key;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TYPE {
        KEYS,
        VALUES,
        ENTRIES;

    }
}

