/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MeteringUtil<T> {
    protected final int BUCKET_SIZE;
    protected final int TIME_UNIT;
    private final Object[] table;
    private long _time_;
    private int _pos_;

    public MeteringUtil() {
        this(1000, 301);
    }

    public MeteringUtil(int bucketSize) {
        this(1000, bucketSize);
    }

    public MeteringUtil(int timeUnit, int bucketSize) {
        this.TIME_UNIT = timeUnit;
        this.BUCKET_SIZE = bucketSize;
        this._time_ = this.getTime();
        this._pos_ = (int)(this._time_ % (long)this.BUCKET_SIZE);
        this.table = new Object[bucketSize];
        for (int i = 0; i < bucketSize; ++i) {
            this.table[i] = this.create();
        }
    }

    protected abstract T create();

    protected abstract void clear(T var1);

    public synchronized T getCurrentBucket() {
        int pos = this.getPosition();
        return (T)this.table[pos];
    }

    public synchronized int getPosition() {
        long curTime = this.getTime();
        if (curTime != this._time_) {
            for (int i = 0; (long)i < curTime - this._time_ && i < this.BUCKET_SIZE; ++i) {
                this._pos_ = this._pos_ + 1 > this.BUCKET_SIZE - 1 ? 0 : this._pos_ + 1;
                this.clear(this.table[this._pos_]);
            }
            this._time_ = curTime;
            this._pos_ = (int)(this._time_ % (long)this.BUCKET_SIZE);
        }
        return this._pos_;
    }

    protected int check(int period) {
        if (period >= this.BUCKET_SIZE) {
            period = this.BUCKET_SIZE - 1;
        }
        return period;
    }

    protected int stepback(int pos) {
        pos = pos == 0 ? this.BUCKET_SIZE - 1 : --pos;
        return pos;
    }

    public int search(int period, Handler<T> h) {
        period = this.check(period);
        int pos = this.getPosition();
        for (int i = 0; i < period; ++i) {
            h.process(this.table[pos]);
            pos = this.stepback(pos);
        }
        return period;
    }

    public T[] search(int period) {
        period = this.check(period);
        int pos = this.getPosition();
        Object[] out = new Object[period];
        for (int i = 0; i < period; ++i) {
            out[i] = this.table[pos];
            pos = this.stepback(pos);
        }
        return out;
    }

    protected long getTime() {
        return System.currentTimeMillis() / (long)this.TIME_UNIT;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Handler<T> {
        public void process(T var1);
    }
}

