/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestQueue<V> {
    private LinkedList<V> queue;
    private int capacity;

    public RequestQueue(int capacity) {
        this.capacity = capacity;
        this.queue = new LinkedList();
    }

    public synchronized V get() {
        while (this.queue.size() <= 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.queue.removeFirst();
    }

    public synchronized V getNoWait() {
        if (this.queue.size() > 0) {
            return this.queue.removeFirst();
        }
        return null;
    }

    public synchronized V get(long timeout) {
        if (this.queue.size() > 0) {
            return this.queue.removeFirst();
        }
        long timeTo = System.currentTimeMillis() + timeout;
        long time = timeout;
        while (this.queue.isEmpty()) {
            try {
                if (time > 0L) {
                    this.wait(time);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((time = timeTo - System.currentTimeMillis()) > 0L) continue;
        }
        if (this.queue.size() > 0) {
            return this.queue.removeFirst();
        }
        return null;
    }

    public synchronized boolean putForce(V o) {
        if (this.capacity <= 0 || this.queue.size() < this.capacity) {
            this.queue.add(o);
            this.notifyAll();
            return true;
        }
        while (this.queue.size() >= this.capacity) {
            this.queue.removeFirst();
        }
        this.queue.add(o);
        this.notifyAll();
        return false;
    }

    public synchronized boolean put(V o) {
        if (this.capacity <= 0 || this.queue.size() < this.capacity) {
            this.queue.add(o);
            this.notifyAll();
            return true;
        }
        this.notify();
        return false;
    }

    public synchronized boolean putNotifySingle(V o) {
        if (this.capacity <= 0 || this.queue.size() < this.capacity) {
            this.queue.add(o);
            this.notify();
            return true;
        }
        this.notify();
        return false;
    }

    public synchronized void clear() {
        this.queue.clear();
    }

    public int size() {
        return this.queue.size();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int size) {
        this.capacity = size;
    }
}

