/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import scouter.util.CompareUtil;
import scouter.util.StringEnumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringKeyLinkedMap<V> {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private StringKeyLinkedEntry<V>[] table;
    private StringKeyLinkedEntry<V> header;
    private int count;
    private int threshold;
    private float loadFactor;
    private int max;

    public StringKeyLinkedMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new StringKeyLinkedEntry[initCapacity];
        this.header = new StringKeyLinkedEntry<Object>(null, null, null);
        this.header.link_prev = this.header;
        this.header.link_next = this.header.link_prev;
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public StringKeyLinkedMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public String[] keyArray() {
        String[] _keys = new String[this.size()];
        StringEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextString();
        }
        return _keys;
    }

    public synchronized StringEnumer keys() {
        return new Enumer(TYPE.KEYS);
    }

    public synchronized Enumeration<V> values() {
        return new Enumer(TYPE.VALUES);
    }

    public synchronized Enumeration<StringKeyLinkedEntry<V>> entries() {
        return new Enumer<StringKeyLinkedEntry<V>>(TYPE.ENTRIES);
    }

    public synchronized boolean containsValue(V value) {
        StringKeyLinkedEntry<V>[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            StringKeyLinkedEntry<V> e = tab[i];
            while (e != null) {
                if (CompareUtil.equals(e.value, value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(String key) {
        StringKeyLinkedEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringKeyLinkedEntry<V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized V get(String key) {
        if (key == null) {
            return null;
        }
        StringKeyLinkedEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringKeyLinkedEntry<V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public synchronized Object getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.header.link_next.value;
    }

    public synchronized Object getLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.header.link_prev.value;
    }

    private int hash(String key) {
        return key.hashCode() & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        StringKeyLinkedEntry<V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        StringKeyLinkedEntry[] newMap = new StringKeyLinkedEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            StringKeyLinkedEntry<V> old = oldMap[i];
            while (old != null) {
                StringKeyLinkedEntry<V> e = old;
                old = old.next;
                String key = e.key;
                int index = this.hash(key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public StringKeyLinkedMap<V> setMax(int max) {
        this.max = max;
        return this;
    }

    public V put(String key, V value) {
        return this._put(key, value, MODE.LAST);
    }

    public V putLast(String key, V value) {
        return this._put(key, value, MODE.FORCE_LAST);
    }

    public V putFirst(String key, V value) {
        return this._put(key, value, MODE.FORCE_FIRST);
    }

    private synchronized V _put(String key, V value, MODE m) {
        if (key == null) {
            return null;
        }
        StringKeyLinkedEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringKeyLinkedEntry<V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.getKey(), key)) {
                Object old = e.value;
                e.value = value;
                switch (m) {
                    case FORCE_FIRST: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case FORCE_LAST: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case FORCE_FIRST: 
                case FIRST: {
                    String k;
                    while (this.count >= this.max) {
                        k = this.header.link_prev.key;
                        V v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case FORCE_LAST: 
                case LAST: {
                    String k;
                    while (this.count >= this.max) {
                        k = this.header.link_next.key;
                        V v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        e = new StringKeyLinkedEntry<V>(key, value, tab[index]);
        tab[index] = e;
        switch (m) {
            case FORCE_FIRST: 
            case FIRST: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case FORCE_LAST: 
            case LAST: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return null;
    }

    public V intern(String key) {
        return this._intern(key, MODE.LAST);
    }

    private synchronized V _intern(String key, MODE m) {
        if (key == null) {
            return null;
        }
        StringKeyLinkedEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringKeyLinkedEntry<V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.getKey(), key)) {
                Object old = e.value;
                switch (m) {
                    case FORCE_FIRST: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case FORCE_LAST: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.next;
        }
        V value = this.create(key);
        if (value == null) {
            return null;
        }
        if (this.max > 0) {
            switch (m) {
                case FORCE_FIRST: 
                case FIRST: {
                    String k;
                    while (this.count >= this.max) {
                        k = this.header.link_prev.key;
                        V v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case FORCE_LAST: 
                case LAST: {
                    String k;
                    while (this.count >= this.max) {
                        k = this.header.link_next.key;
                        V v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        StringKeyLinkedEntry<V> e2 = new StringKeyLinkedEntry<V>(key, value, tab[index]);
        tab[index] = e2;
        switch (m) {
            case FORCE_FIRST: 
            case FIRST: {
                this.chain(this.header, this.header.link_next, e2);
                break;
            }
            case FORCE_LAST: 
            case LAST: {
                this.chain(this.header.link_prev, this.header, e2);
            }
        }
        ++this.count;
        return value;
    }

    protected void overflowed(String key, V value) {
    }

    protected V create(String key) {
        throw new RuntimeException("not implemented create()");
    }

    public synchronized V remove(String key) {
        if (key == null) {
            return null;
        }
        StringKeyLinkedEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringKeyLinkedEntry<V> e = tab[index];
        StringKeyLinkedEntry<V> prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                this.unchain(e);
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized V removeFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized V removeLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void clear() {
        StringKeyLinkedEntry<V>[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_prev = this.header;
        this.header.link_next = this.header.link_prev;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<StringKeyLinkedEntry<V>> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            StringKeyLinkedEntry<V> e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<StringKeyLinkedEntry<V>> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            StringKeyLinkedEntry<V> e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(StringKeyLinkedEntry link_prev, StringKeyLinkedEntry link_next, StringKeyLinkedEntry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(StringKeyLinkedEntry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public static void main(String[] args) {
    }

    private static void print(Object e) {
        System.out.println(e);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Enumer<V>
    implements Enumeration<V>,
    StringEnumer {
        TYPE type;
        StringKeyLinkedEntry entry;

        Enumer(TYPE type) {
            this.entry = ((StringKeyLinkedMap)StringKeyLinkedMap.this).header.link_next;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            return StringKeyLinkedMap.this.header != this.entry && this.entry != null;
        }

        @Override
        public V nextElement() {
            if (this.hasMoreElements()) {
                StringKeyLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case KEYS: {
                        return (V)e.key;
                    }
                    case VALUES: {
                        return e.value;
                    }
                }
                return (V)e;
            }
            throw new NoSuchElementException("no more  next");
        }

        @Override
        public String nextString() {
            if (this.hasMoreElements()) {
                StringKeyLinkedEntry e = this.entry;
                this.entry = e.link_next;
                return e.key;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TYPE {
        KEYS,
        VALUES,
        ENTRIES;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringKeyLinkedEntry<V> {
        String key;
        V value;
        StringKeyLinkedEntry<V> next;
        StringKeyLinkedEntry<V> link_next;
        StringKeyLinkedEntry<V> link_prev;

        protected StringKeyLinkedEntry(String key, V value, StringKeyLinkedEntry<V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new StringKeyLinkedEntry<V>(this.key, this.value, this.next == null ? null : (StringKeyLinkedEntry)this.next.clone());
        }

        public String getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StringKeyLinkedEntry)) {
                return false;
            }
            StringKeyLinkedEntry e = (StringKeyLinkedEntry)o;
            return CompareUtil.equals(e.key, this.key) && CompareUtil.equals(e.value, this.value);
        }

        public int hashCode() {
            return this.key.hashCode() ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MODE {
        FORCE_FIRST,
        FORCE_LAST,
        FIRST,
        LAST;

    }
}

