/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.Arrays;
import java.util.NoSuchElementException;
import scouter.util.CompareUtil;
import scouter.util.StringEnumer;

public class StringLinkedSet {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private StringLinkedSetry[] table;
    private StringLinkedSetry header;
    private int count;
    private int threshold;
    private float loadFactor;
    private int max;

    public StringLinkedSet(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new StringLinkedSetry[initCapacity];
        this.header = new StringLinkedSetry(null, null);
        this.header.link_next = this.header.link_prev = this.header;
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public StringLinkedSet() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public String[] getArray() {
        String[] _keys = new String[this.size()];
        StringEnumer en = this.elements();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextString();
        }
        return _keys;
    }

    public synchronized StringEnumer elements() {
        return new Enumer();
    }

    public synchronized boolean contains(String key) {
        if (key == null) {
            return false;
        }
        StringLinkedSetry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringLinkedSetry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized String getFirst() {
        return this.header.link_next.key;
    }

    public synchronized String getLast() {
        return this.header.link_prev.key;
    }

    private int hash(String key) {
        return key.hashCode() & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        StringLinkedSetry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        StringLinkedSetry[] newMap = new StringLinkedSetry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            StringLinkedSetry old = oldMap[i];
            while (old != null) {
                StringLinkedSetry e = old;
                old = old.next;
                String key = e.key;
                int index = this.hash(key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public StringLinkedSet setMax(int max) {
        this.max = max;
        return this;
    }

    public String put(String key) {
        return this._put(key, MODE.LAST);
    }

    public String putLast(String key) {
        return this._put(key, MODE.FORCE_LAST);
    }

    public String putFirst(String key) {
        return this._put(key, MODE.FORCE_FIRST);
    }

    private synchronized String _put(String key, MODE m) {
        StringLinkedSetry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringLinkedSetry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                switch (m) {
                    case FORCE_FIRST: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case FORCE_LAST: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return e.key;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case FORCE_FIRST: 
                case FIRST: {
                    String v;
                    while (this.count >= this.max) {
                        v = this.header.link_prev.key;
                        this.remove(v);
                        this.overflowed(v);
                    }
                    break;
                }
                case FORCE_LAST: 
                case LAST: {
                    String v;
                    while (this.count >= this.max) {
                        v = this.header.link_next.key;
                        this.remove(v);
                        this.overflowed(v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new StringLinkedSetry(key, tab[index]);
        switch (m) {
            case FORCE_FIRST: 
            case FIRST: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case FORCE_LAST: 
            case LAST: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return null;
    }

    protected void overflowed(String value) {
    }

    public String unipoint(String key) {
        String old = this._put(key, MODE.LAST);
        return old == null ? key : old;
    }

    public synchronized String remove(String key) {
        if (key == null) {
            return null;
        }
        StringLinkedSetry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringLinkedSetry e = tab[index];
        StringLinkedSetry prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                this.unchain(e);
                return key;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized String removeFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized String removeLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void clear() {
        StringLinkedSetry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_next = this.header.link_prev = this.header;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        StringEnumer it = this.elements();
        buf.append("{");
        while (it.hasMoreElements()) {
            if (buf.length() > 1) {
                buf.append(",");
            }
            buf.append(it.nextString());
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(StringLinkedSetry link_prev, StringLinkedSetry link_next, StringLinkedSetry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(StringLinkedSetry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public synchronized void sort(boolean asc) {
        if (this.size() <= 1) {
            return;
        }
        Object[] list = new String[this.size()];
        StringEnumer en = this.elements();
        int i = 0;
        while (en.hasMoreElements()) {
            list[i] = en.nextString();
            ++i;
        }
        Arrays.sort(list);
        this.clear();
        if (asc) {
            for (Object n : list) {
                this.put((String)n);
            }
        } else {
            for (i = list.length - 1; i >= 0; --i) {
                this.put((String)list[i]);
            }
        }
    }

    public static void main(String[] args) {
        StringLinkedSet s = new StringLinkedSet();
        s.put("aa");
        s.put("bb");
        s.put("00");
        s.sort(true);
        System.out.println(s);
        s.sort(false);
        System.out.println(s);
    }

    private class Enumer
    implements StringEnumer {
        StringLinkedSetry entry;

        private Enumer() {
            this.entry = ((StringLinkedSet)StringLinkedSet.this).header.link_next;
        }

        public boolean hasMoreElements() {
            return StringLinkedSet.this.header != this.entry && this.entry != null;
        }

        public String nextString() {
            if (this.hasMoreElements()) {
                StringLinkedSetry e = this.entry;
                this.entry = e.link_next;
                return e.key;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringLinkedSetry<V> {
        String key;
        StringLinkedSetry<V> next;
        StringLinkedSetry<V> link_next;
        StringLinkedSetry<V> link_prev;

        protected StringLinkedSetry(String key, StringLinkedSetry<V> next) {
            this.key = key;
            this.next = next;
        }

        protected Object clone() {
            return new StringLinkedSetry<V>(this.key, this.next == null ? null : (StringLinkedSetry)this.next.clone());
        }

        public String getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StringLinkedSetry)) {
                return false;
            }
            StringLinkedSetry e = (StringLinkedSetry)o;
            return CompareUtil.equals(e.key, this.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return this.key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MODE {
        FORCE_FIRST,
        FORCE_LAST,
        FIRST,
        LAST;

    }
}

