/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.List;
import scouter.util.FileUtil;
import scouter.util.StringUtil;
import scouter.util.SystemUtil;

public class SysJMX {
    private static ThreadMXBean threadmx;
    private static OperatingSystemMXBean osmx;
    private static RuntimeMXBean rtmx;
    private static Method getSystemLoadAverage;
    private static Method getProcessCpuTime;
    private static boolean sunThreadMX;
    private static String hostname;

    public static long getCurrentThreadCPU() {
        if (threadmx == null) {
            return 0L;
        }
        try {
            return threadmx.getCurrentThreadCpuTime() / 1000000L;
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    public static long getCurrentThreadCPUnano() {
        if (threadmx == null) {
            return 0L;
        }
        try {
            return threadmx.getCurrentThreadCpuTime();
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    public static long getCurrentThreadAllocBytes() {
        if (!sunThreadMX) {
            return 0L;
        }
        try {
            return ((com.sun.management.ThreadMXBean)threadmx).getThreadAllocatedBytes(Thread.currentThread().getId());
        }
        catch (Throwable t) {
            sunThreadMX = false;
            return 0L;
        }
    }

    public static long getThreadCPU(long id) {
        if (threadmx == null) {
            return 0L;
        }
        try {
            return threadmx.getThreadCpuTime(id) / 1000000L;
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    public static long getCurrentProcGcTime() {
        if (threadmx == null) {
            return 0L;
        }
        try {
            List<GarbageCollectorMXBean> gclist = ManagementFactory.getGarbageCollectorMXBeans();
            long gctime = 0L;
            for (int i = 0; i < gclist.size(); ++i) {
                GarbageCollectorMXBean mxs = gclist.get(i);
                gctime += mxs.getCollectionTime();
            }
            return gctime;
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    public static long[] getCurrentProcGcInfo() {
        long[] gc = new long[2];
        if (threadmx == null) {
            return gc;
        }
        try {
            List<GarbageCollectorMXBean> gclist = ManagementFactory.getGarbageCollectorMXBeans();
            for (int i = 0; i < gclist.size(); ++i) {
                GarbageCollectorMXBean mxs = gclist.get(i);
                gc[0] = gc[0] + mxs.getCollectionCount();
                gc[1] = gc[1] + mxs.getCollectionTime();
            }
            return gc;
        }
        catch (Throwable t) {
            return gc;
        }
    }

    public static float getSystemLoad() {
        if (getSystemLoadAverage == null) {
            return 0.0f;
        }
        try {
            Object o = getSystemLoadAverage.invoke((Object)osmx, new Object[0]);
            return ((Float)o).floatValue();
        }
        catch (Throwable t) {
            return 0.0f;
        }
    }

    public static boolean isProcessCPU() {
        return getProcessCpuTime != null;
    }

    public static long getProcessCPU() {
        if (getProcessCpuTime == null) {
            return 0L;
        }
        try {
            Object o = getProcessCpuTime.invoke((Object)osmx, new Object[0]);
            return (Long)o;
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    public static int getProcessPID() {
        RuntimeMXBean o = ManagementFactory.getRuntimeMXBean();
        String nm = o.getName();
        int x = nm.indexOf("@");
        try {
            if (x > 0) {
                return Integer.parseInt(nm.substring(0, x));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHostName() {
        if (hostname != null) {
            return hostname;
        }
        if (SystemUtil.IS_LINUX) {
            String string;
            InputStream is = null;
            OutputStream os = null;
            InputStream es = null;
            try {
                Process process2 = Runtime.getRuntime().exec("hostname");
                is = process2.getInputStream();
                os = process2.getOutputStream();
                es = process2.getErrorStream();
                byte[] isBytes = FileUtil.readAll(is);
                hostname = new String(isBytes);
                if (StringUtil.isNotEmpty(hostname)) {
                    hostname = hostname.replaceAll("\n", "");
                    hostname = hostname.replaceAll("\r", "");
                }
                string = hostname;
            }
            catch (Throwable th) {
                try {
                    th.printStackTrace();
                }
                catch (Throwable throwable) {
                    FileUtil.close(is);
                    FileUtil.close(os);
                    FileUtil.close(es);
                    throw throwable;
                }
                FileUtil.close(is);
                FileUtil.close(os);
                FileUtil.close(es);
            }
            FileUtil.close(is);
            FileUtil.close(os);
            FileUtil.close(es);
            return string;
        }
        RuntimeMXBean o = ManagementFactory.getRuntimeMXBean();
        String nm = o.getName();
        int x = nm.indexOf("@");
        hostname = nm.substring(x + 1);
        return hostname;
    }

    public static String getProcessName() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }

    public static long getThreadCpuTime(Thread thread) {
        if (threadmx == null) {
            return 0L;
        }
        return threadmx.getThreadCpuTime(thread.getId()) / 1000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserName() {
        String username = SystemUtil.USER_NAME;
        if (StringUtil.isNotEmpty(username)) {
            return username;
        }
        username = System.getenv("USERNAME");
        if (StringUtil.isNotEmpty(username)) {
            return username;
        }
        InputStream is = null;
        OutputStream os = null;
        InputStream es = null;
        try {
            Process process2 = Runtime.getRuntime().exec("whoami");
            is = process2.getInputStream();
            os = process2.getOutputStream();
            es = process2.getErrorStream();
            byte[] isBytes = FileUtil.readAll(is);
            username = new String(isBytes);
        }
        catch (Throwable th) {
            try {
                th.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtil.close(is);
                FileUtil.close(os);
                FileUtil.close(es);
                throw throwable;
            }
            FileUtil.close(is);
            FileUtil.close(os);
            FileUtil.close(es);
        }
        FileUtil.close(is);
        FileUtil.close(os);
        FileUtil.close(es);
        return username;
    }

    public static String getUsingJava() {
        return SystemUtil.JAVA_VERSION;
    }

    static {
        sunThreadMX = false;
        try {
            threadmx = ManagementFactory.getThreadMXBean();
            osmx = ManagementFactory.getOperatingSystemMXBean();
            rtmx = ManagementFactory.getRuntimeMXBean();
            sunThreadMX = threadmx.getClass().getName().indexOf("sun") >= 0;
        }
        catch (Throwable t) {
            threadmx = null;
            osmx = null;
            rtmx = null;
            sunThreadMX = false;
        }
        try {
            if (osmx != null) {
                Class<?> c = osmx.getClass();
                getSystemLoadAverage = c.getMethod("getSystemLoadAverage", new Class[0]);
                getProcessCpuTime = c.getMethod("getProcessCpuTime", new Class[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        hostname = null;
    }
}

