/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipFileUtil {
    private static final int FILE_BUFFER_SIZE = 8096;

    public static void sendZipFile(ZipOutputStream zos, File file) throws Exception {
        String zipFilename = file.getAbsolutePath();
        int index = zipFilename.lastIndexOf(File.separator);
        if (index >= 0) {
            zipFilename = zipFilename.substring(index + 1);
        }
        ZipEntry zipEntry = new ZipEntry(zipFilename);
        zipEntry.setMethod(8);
        zipEntry.setSize(file.length());
        zos.putNextEntry(zipEntry);
        int readSize = 0;
        byte[] buffer = new byte[8096];
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        while (0 != (readSize = bis.read(buffer)) && -1 != readSize) {
            zos.write(buffer, 0, readSize);
        }
        bis.close();
    }

    public static void recieveZipFile(ZipInputStream zis, String relativePath) throws Exception {
        ZipEntry zipEntry = null;
        while (null != (zipEntry = zis.getNextEntry())) {
            int fileLength;
            File outFile = new File(relativePath + "/" + zipEntry.getName());
            File parentFolder = outFile.getParentFile();
            if (!parentFolder.exists()) {
                parentFolder.mkdirs();
            }
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(outFile));
            int remainLength = fileLength = (int)zipEntry.getSize();
            byte[] buffer = new byte[8096];
            int readSize = ZipFileUtil.caculReadSize(remainLength);
            while ((readSize = zis.read(buffer, 0, readSize)) > 0) {
                fos.write(buffer, 0, readSize);
                remainLength -= readSize;
                readSize = ZipFileUtil.caculReadSize(remainLength);
            }
            fos.close();
        }
    }

    private static int caculReadSize(int remainLength) {
        if (remainLength >= 8096) {
            return 8096;
        }
        return remainLength;
    }
}

