/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.framework.client.model;

import java.util.HashMap;
import java.util.Map;
import scouterx.webapp.framework.client.model.TextModel;
import scouterx.webapp.framework.client.model.TextProxy;

public enum TextTypeEnum {
    ERROR("error", TextProxy.error),
    APICALL("apicall", TextProxy.apicall),
    METHOD("method", TextProxy.method),
    SERVICE("service", TextProxy.service),
    SQL("sql", TextProxy.sql),
    OBJECT("object", TextProxy.object),
    REFERRER("referer", TextProxy.referrer),
    USER_AGENT("ua", TextProxy.userAgent),
    GROUP("group", TextProxy.group),
    CITY("city", TextProxy.city),
    SQL_TABLES("table", TextProxy.sql_tables),
    MARIA("maria", TextProxy.maria),
    LOGIN("login", TextProxy.login),
    DESC("desc", TextProxy.desc),
    WEB("web", TextProxy.web),
    HASH_MSG("hmsg", TextProxy.hashMessage),
    STACK_ELEMENT("stackelem", TextProxy.stackElement);

    private static final Map<TextModel, TextTypeEnum> modelMap;
    private static final Map<String, TextTypeEnum> nameMap;
    private final String typeName;
    private final TextModel textModel;

    private TextTypeEnum(String typeName, TextModel textModel) {
        this.typeName = typeName;
        this.textModel = textModel;
    }

    public static TextTypeEnum of(TextModel textModel) {
        return modelMap.get(textModel);
    }

    public static TextTypeEnum of(String typeName) {
        return nameMap.get(typeName);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public TextModel getTextModel() {
        return this.textModel;
    }

    static {
        modelMap = new HashMap<TextModel, TextTypeEnum>();
        nameMap = new HashMap<String, TextTypeEnum>();
        for (TextTypeEnum textTypeEnum : TextTypeEnum.values()) {
            modelMap.put(textTypeEnum.textModel, textTypeEnum);
            nameMap.put(textTypeEnum.typeName, textTypeEnum);
        }
    }
}

