/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.framework.client.thread;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scouter.util.ThreadUtil;
import scouterx.webapp.framework.client.net.LoginMgr;
import scouterx.webapp.framework.client.net.LoginRequest;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.configure.ConfigureAdaptor;
import scouterx.webapp.framework.configure.ConfigureManager;

public class ServerSessionObserver
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ServerSessionObserver.class);
    public static final ConfigureAdaptor conf = ConfigureManager.getConfigure();
    private static ServerSessionObserver observer;
    private static final long CHECK_INTERVAL = 5000L;

    public static synchronized void load() {
        if (observer == null) {
            observer = new ServerSessionObserver();
            observer.setDaemon(true);
            observer.setName("ServerSessionObserverThread");
            observer.start();
        }
    }

    @Override
    public void run() {
        ThreadUtil.sleep((long)5000L);
        while (true) {
            this.process();
            ThreadUtil.sleep((long)5000L);
        }
    }

    private void process() {
        try {
            Set<Integer> idSet = ServerManager.getInstance().getOpenServerIdList();
            for (int serverId : idSet) {
                Server server = ServerManager.getInstance().getServer(serverId);
                if (server == null || server.getSession() != 0L) continue;
                LoginRequest result = LoginMgr.login(server);
                if (result.success) {
                    log.info("Success re-login to {}", (Object)server.getName());
                    continue;
                }
                log.error("Failed re-login to {} : {}", (Object)server.getName(), (Object)result.getErrorMessage());
            }
            Set<Integer> closedSet = ServerManager.getInstance().getClosedServerIdList();
            for (int serverId : closedSet) {
                Server server = ServerManager.getInstance().getServer(serverId);
                if (server == null) continue;
                LoginRequest result = LoginMgr.login(server);
                if (result.success) {
                    log.info("Success re-login to {}", (Object)server.getName());
                    continue;
                }
                log.error("Failed re-login to {} : {}", (Object)server.getName(), (Object)result.getErrorMessage());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

