/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.consumer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouterx.webapp.framework.client.net.TcpProxy;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.model.HostDiskData;
import scouterx.webapp.model.ProcessObject;

public class HostObjectRequestConsumer {
    private static final Logger log = LoggerFactory.getLogger(HostObjectRequestConsumer.class);

    public List<ProcessObject> retrieveRealTimeTopByObjType(int objHash, Server server) {
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            MapPack mapPack = new MapPack();
            mapPack.put("objHash", (long)objHash);
            MapPack outMapPack = (MapPack)tcpProxy.getSingle("HOST_TOP", (Pack)mapPack);
            if (outMapPack == null) {
                List<ProcessObject> list = null;
                return list;
            }
            List<String> hostTopKeys = Arrays.asList("PID", "USER", "CPU", "MEM", "TIME", "NAME");
            HashMap<String, ListValue> hostTopMap = new HashMap<String, ListValue>();
            hostTopKeys.forEach(key -> hostTopMap.put((String)key, outMapPack.getList(key)));
            ArrayList<ProcessObject> procList = new ArrayList<ProcessObject>();
            int pidLoopCount = 0;
            if (hostTopMap.containsKey("PID")) {
                pidLoopCount = ((ListValue)hostTopMap.get("PID")).size();
            }
            for (int i = 0; i < pidLoopCount; ++i) {
                procList.add(new ProcessObject(hostTopMap, i));
            }
            ArrayList<ProcessObject> arrayList = procList;
            return arrayList;
        }
    }

    public List<HostDiskData> retrieveRealTimeDiskByObjType(int objHash, Server server) {
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            MapPack mapPack = new MapPack();
            mapPack.put("objHash", (long)objHash);
            MapPack outMapPack = (MapPack)tcpProxy.getSingle("HOST_DISK_USAGE", (Pack)mapPack);
            if (outMapPack == null) {
                List<HostDiskData> list = null;
                return list;
            }
            List<String> hostDiskKeys = Arrays.asList("Device", "Total", "Used", "Free", "Pct", "Type", "Mount");
            HashMap<String, ListValue> hostDiskMap = new HashMap<String, ListValue>();
            hostDiskKeys.forEach(key -> hostDiskMap.put((String)key, outMapPack.getList(key)));
            ArrayList<HostDiskData> dataList = new ArrayList<HostDiskData>();
            int diskLoopCount = 0;
            if (hostDiskMap.containsKey("Device")) {
                diskLoopCount = ((ListValue)hostDiskMap.get("Device")).size();
            }
            for (int i = 0; i < diskLoopCount; ++i) {
                dataList.add(new HostDiskData(hostDiskMap, i));
            }
            ArrayList<HostDiskData> arrayList = dataList;
            return arrayList;
        }
    }
}

