/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.consumer;

import java.util.ArrayList;
import java.util.List;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.util.DateTimeHelper;
import scouterx.webapp.framework.client.net.TcpProxy;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.dto.DateAndMapPack;
import scouterx.webapp.model.summary.AlertSummaryItem;
import scouterx.webapp.model.summary.ApiCallSummaryItem;
import scouterx.webapp.model.summary.ErrorSummaryItem;
import scouterx.webapp.model.summary.IpSummaryItem;
import scouterx.webapp.model.summary.ServiceSummaryItem;
import scouterx.webapp.model.summary.SqlSummaryItem;
import scouterx.webapp.model.summary.Summary;
import scouterx.webapp.model.summary.UserAgentSummaryItem;
import scouterx.webapp.request.SummaryRequest;

public class SummaryConsumer {
    public Summary<ServiceSummaryItem> retrieveServiceSummary(SummaryRequest request) {
        String cmd = "LOAD_SERVICE_SUMMARY";
        List<DateAndMapPack> resultPackList = this.retrieveSummary(cmd, request.getStartTimeMillis(), request.getEndTimeMillis(), request.getObjType(), request.getObjHash(), request.getServer());
        Summary<ServiceSummaryItem> summary = Summary.of(ServiceSummaryItem.class, resultPackList, request.getServer().getId());
        return summary;
    }

    public Summary<SqlSummaryItem> retrieveSqlSummary(SummaryRequest request) {
        String cmd = "LOAD_SQL_SUMMARY";
        List<DateAndMapPack> resultPackList = this.retrieveSummary(cmd, request.getStartTimeMillis(), request.getEndTimeMillis(), request.getObjType(), request.getObjHash(), request.getServer());
        Summary<SqlSummaryItem> summary = Summary.of(SqlSummaryItem.class, resultPackList, request.getServer().getId());
        return summary;
    }

    public Summary<ApiCallSummaryItem> retrieveApiCallSummary(SummaryRequest request) {
        String cmd = "LOAD_APICALL_SUMMARY";
        List<DateAndMapPack> resultPackList = this.retrieveSummary(cmd, request.getStartTimeMillis(), request.getEndTimeMillis(), request.getObjType(), request.getObjHash(), request.getServer());
        Summary<ApiCallSummaryItem> summary = Summary.of(ApiCallSummaryItem.class, resultPackList, request.getServer().getId());
        return summary;
    }

    public Summary<IpSummaryItem> retrieveIpSummary(SummaryRequest request) {
        String cmd = "LOAD_IP_SUMMARY";
        List<DateAndMapPack> resultPackList = this.retrieveSummary(cmd, request.getStartTimeMillis(), request.getEndTimeMillis(), request.getObjType(), request.getObjHash(), request.getServer());
        Summary<IpSummaryItem> summary = Summary.of(IpSummaryItem.class, resultPackList, request.getServer().getId());
        return summary;
    }

    public Summary<UserAgentSummaryItem> retrieveUserAgentSummary(SummaryRequest request) {
        String cmd = "LOAD_UA_SUMMARY";
        List<DateAndMapPack> resultPackList = this.retrieveSummary(cmd, request.getStartTimeMillis(), request.getEndTimeMillis(), request.getObjType(), request.getObjHash(), request.getServer());
        Summary<UserAgentSummaryItem> summary = Summary.of(UserAgentSummaryItem.class, resultPackList, request.getServer().getId());
        return summary;
    }

    public Summary<ErrorSummaryItem> retrieveErrorSummary(SummaryRequest request) {
        String cmd = "LOAD_SERVICE_ERROR_SUMMARY";
        List<DateAndMapPack> resultPackList = this.retrieveSummary(cmd, request.getStartTimeMillis(), request.getEndTimeMillis(), request.getObjType(), request.getObjHash(), request.getServer());
        Summary<ErrorSummaryItem> summary = Summary.of(ErrorSummaryItem.class, resultPackList, request.getServer().getId());
        return summary;
    }

    public Summary<AlertSummaryItem> retrieveAlertSummary(SummaryRequest request) {
        String cmd = "LOAD_ALERT_SUMMARY";
        List<DateAndMapPack> resultPackList = this.retrieveSummary(cmd, request.getStartTimeMillis(), request.getEndTimeMillis(), request.getObjType(), request.getObjHash(), request.getServer());
        Summary<AlertSummaryItem> summary = Summary.of(AlertSummaryItem.class, resultPackList, request.getServer().getId());
        return summary;
    }

    private List<DateAndMapPack> retrieveSummary(String cmd, long start, long end, String objType, int objHash, Server server) {
        DateTimeHelper helper = DateTimeHelper.getDefault();
        long startDateUnit = helper.getDateUnit(start);
        long endDateUnit = helper.getDateUnit(end);
        ArrayList<DateAndMapPack> dateAndMapPackList = new ArrayList<DateAndMapPack>();
        for (long dateUnit = startDateUnit; dateUnit <= endDateUnit; ++dateUnit) {
            SearchCondition condition = this.generateSearchCondition(helper, dateUnit, startDateUnit, endDateUnit, start, end);
            MapPack summaryResultMapPack = this.retrieveDailySummaryPack(cmd, condition.yyyymmdd, condition.start, condition.end, objType, objHash, server);
            dateAndMapPackList.add(new DateAndMapPack(condition.yyyymmdd, summaryResultMapPack));
        }
        return dateAndMapPackList;
    }

    private SearchCondition generateSearchCondition(DateTimeHelper helper, long dateUnit, long startDateUnit, long endDateUnit, long start, long end) {
        long _end;
        long _start;
        if (dateUnit < endDateUnit) {
            _start = dateUnit == startDateUnit ? start : helper.dateUnitToTimeMillis(dateUnit);
            _end = helper.dateUnitToTimeMillis(dateUnit) + 86400000L - 1000L;
        } else {
            _start = dateUnit == startDateUnit ? start : helper.dateUnitToTimeMillis(dateUnit);
            _end = end;
        }
        String _yyyymmdd = helper.yyyymmdd(_start);
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.yyyymmdd = _yyyymmdd;
        searchCondition.start = _start;
        searchCondition.end = _end;
        return searchCondition;
    }

    private MapPack retrieveDailySummaryPack(String cmd, String yyyymmdd, long start, long end, String objType, int objHash, Server server) {
        Pack resultPack;
        MapPack paramPack = new MapPack();
        paramPack.put("date", yyyymmdd);
        paramPack.put("stime", start);
        paramPack.put("etime", end);
        if (objType != null) {
            paramPack.put("objType", objType);
        }
        paramPack.put("objHash", (long)objHash);
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            resultPack = tcpProxy.getSingle(cmd, (Pack)paramPack);
        }
        return (MapPack)resultPack;
    }

    private static class SearchCondition {
        private String yyyymmdd;
        private long start;
        private long end;

        public String getYyyymmdd() {
            return this.yyyymmdd;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public void setYyyymmdd(String yyyymmdd) {
            this.yyyymmdd = yyyymmdd;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public void setEnd(long end) {
            this.end = end;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SearchCondition)) {
                return false;
            }
            SearchCondition other = (SearchCondition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$yyyymmdd = this.getYyyymmdd();
            String other$yyyymmdd = other.getYyyymmdd();
            if (this$yyyymmdd == null ? other$yyyymmdd != null : !this$yyyymmdd.equals(other$yyyymmdd)) {
                return false;
            }
            if (this.getStart() != other.getStart()) {
                return false;
            }
            return this.getEnd() == other.getEnd();
        }

        protected boolean canEqual(Object other) {
            return other instanceof SearchCondition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $yyyymmdd = this.getYyyymmdd();
            result = result * 59 + ($yyyymmdd == null ? 43 : $yyyymmdd.hashCode());
            long $start = this.getStart();
            result = result * 59 + (int)($start >>> 32 ^ $start);
            long $end = this.getEnd();
            result = result * 59 + (int)($end >>> 32 ^ $end);
            return result;
        }

        public String toString() {
            return "SummaryConsumer.SearchCondition(yyyymmdd=" + this.getYyyymmdd() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ")";
        }
    }
}

