/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import io.swagger.annotations.Api;
import java.util.List;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.util.ZZ;
import scouterx.webapp.layer.service.CustomKvStoreService;
import scouterx.webapp.model.KeyValueData;
import scouterx.webapp.request.SetKvBulkRequest;
import scouterx.webapp.request.SetKvRequest;
import scouterx.webapp.request.SetKvTTLRequest;
import scouterx.webapp.view.CommonResultView;

@Path(value="/v1/kv/space")
@Api(value="CustomKeyValueStore")
@Singleton
@Produces(value={"application/json"})
public class CustomKvStoreController {
    private final CustomKvStoreService kvStoreService = new CustomKvStoreService();

    @GET
    @Path(value="/{keySpace}/{key}")
    @Consumes(value={"application/json"})
    public CommonResultView<String> get(@PathParam(value="keySpace") String keySpace, @PathParam(value="key") String key, @QueryParam(value="serverId") int serverId) {
        String result = this.kvStoreService.get(keySpace, key, ServerManager.getInstance().getServerIfNullDefault(serverId));
        return CommonResultView.success(result);
    }

    @PUT
    @Path(value="/{keySpace}")
    @Consumes(value={"application/json"})
    public CommonResultView<Boolean> set(@PathParam(value="keySpace") String keySpace, SetKvRequest request) {
        this.kvStoreService.set(keySpace, request.getKey(), request.getValue(), request.getTtl(), ServerManager.getInstance().getServerIfNullDefault(request.getServerId()));
        return CommonResultView.success(true);
    }

    @PUT
    @Path(value="/{keySpace}/{key}/:ttl")
    @Consumes(value={"application/json"})
    public CommonResultView<Boolean> set(@PathParam(value="keySpace") String keySpace, @PathParam(value="key") String key, SetKvTTLRequest request) {
        this.kvStoreService.setTTL(keySpace, key, request.getTtl(), ServerManager.getInstance().getServerIfNullDefault(request.getServerId()));
        return CommonResultView.success(true);
    }

    @GET
    @Path(value="/{keySpace}/{keys}/:bulk")
    @Consumes(value={"application/json"})
    public CommonResultView<List<KeyValueData>> getBulk(@PathParam(value="keySpace") String keySpace, @PathParam(value="keys") String keyBySeparator, @QueryParam(value="serverId") int serverId) {
        List<KeyValueData> resultList = this.kvStoreService.getBulk(keySpace, ZZ.splitParam(keyBySeparator), ServerManager.getInstance().getServerIfNullDefault(serverId));
        return CommonResultView.success(resultList);
    }

    @PUT
    @Path(value="/{keySpace}/:bulk")
    @Consumes(value={"application/json"})
    public CommonResultView<List<KeyValueData>> setBulk(@PathParam(value="keySpace") String keySpace, SetKvBulkRequest request) {
        List<KeyValueData> resultList = this.kvStoreService.setBulk(keySpace, request.toMap(), request.getTtl(), ServerManager.getInstance().getServerIfNullDefault(request.getServerId()));
        return CommonResultView.success(resultList);
    }
}

