/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import io.swagger.annotations.Api;
import java.util.List;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.util.ZZ;
import scouterx.webapp.layer.service.GlobalKvStoreService;
import scouterx.webapp.model.KeyValueData;
import scouterx.webapp.request.SetKvBulkRequest;
import scouterx.webapp.request.SetKvRequest;
import scouterx.webapp.request.SetKvTTLRequest;
import scouterx.webapp.view.CommonResultView;

@Path(value="/v1/kv")
@Api(value="GlobalKeyValueStore")
@Singleton
@Produces(value={"application/json"})
public class GlobalKvStoreController {
    private final GlobalKvStoreService kvStoreService = new GlobalKvStoreService();

    @GET
    @Path(value="/{key}")
    @Consumes(value={"application/json"})
    public CommonResultView<String> get(@PathParam(value="key") String key, @QueryParam(value="serverId") int serverId) {
        String result = this.kvStoreService.get(key, ServerManager.getInstance().getServerIfNullDefault(serverId));
        return CommonResultView.success(result);
    }

    @PUT
    @Consumes(value={"application/json"})
    public CommonResultView<Boolean> set(SetKvRequest request) {
        this.kvStoreService.set(request.getKey(), request.getValue(), request.getTtl(), ServerManager.getInstance().getServerIfNullDefault(request.getServerId()));
        return CommonResultView.success(true);
    }

    @PUT
    @Path(value="/{key}/:ttl")
    @Consumes(value={"application/json"})
    public CommonResultView<Boolean> set(@PathParam(value="key") String key, SetKvTTLRequest request) {
        this.kvStoreService.setTTL(key, request.getTtl(), ServerManager.getInstance().getServerIfNullDefault(request.getServerId()));
        return CommonResultView.success(true);
    }

    @GET
    @Path(value="/{keys}/:bulk")
    @Consumes(value={"application/json"})
    public CommonResultView<List<KeyValueData>> getBulk(@PathParam(value="keys") String keyBySeparator, @QueryParam(value="serverId") int serverId) {
        List<KeyValueData> resultList = this.kvStoreService.getBulk(ZZ.splitParam(keyBySeparator), ServerManager.getInstance().getServerIfNullDefault(serverId));
        return CommonResultView.success(resultList);
    }

    @PUT
    @Path(value="/:bulk")
    @Consumes(value={"application/json"})
    public CommonResultView<List<KeyValueData>> setBulk(SetKvBulkRequest request) {
        List<KeyValueData> resultList = this.kvStoreService.setBulk(request.toMap(), request.getTtl(), ServerManager.getInstance().getServerIfNullDefault(request.getServerId()));
        return CommonResultView.success(resultList);
    }
}

