/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import io.swagger.annotations.Api;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.exception.ErrorState;
import scouterx.webapp.framework.session.UserToken;
import scouterx.webapp.framework.session.WebRequestContext;
import scouterx.webapp.framework.util.ZZ;
import scouterx.webapp.layer.service.CustomKvStoreService;
import scouterx.webapp.model.KeyValueData;
import scouterx.webapp.request.SetKvBulkRequest;
import scouterx.webapp.request.SetKvRequest;
import scouterx.webapp.request.SetKvTTLRequest;
import scouterx.webapp.view.CommonResultView;

@Path(value="/v1/kv-private")
@Api(value="PrivateKeyValueStore - login user private space")
@Singleton
@Produces(value={"application/json"})
public class PrivateKvStoreController {
    private static final String KEYSPACE_WEB_SESSION_PRIVATE = "___WEB_SESSION_PRIVATE___";
    private final CustomKvStoreService kvStoreService = new CustomKvStoreService();

    @GET
    @Path(value="/{key}")
    @Consumes(value={"application/json"})
    public CommonResultView<String> get(@PathParam(value="key") String key, @QueryParam(value="serverId") int serverId) {
        String result = this.kvStoreService.get(KEYSPACE_WEB_SESSION_PRIVATE, this.toPrivateKey(key), ServerManager.getInstance().getServerIfNullDefault(serverId));
        return CommonResultView.success(result);
    }

    @PUT
    @Consumes(value={"application/json"})
    public CommonResultView<Boolean> set(SetKvRequest request) {
        this.kvStoreService.set(KEYSPACE_WEB_SESSION_PRIVATE, this.toPrivateKey(request.getKey()), request.getValue(), request.getTtl(), ServerManager.getInstance().getServerIfNullDefault(request.getServerId()));
        return CommonResultView.success(true);
    }

    @PUT
    @Path(value="/{key}/:ttl")
    @Consumes(value={"application/json"})
    public CommonResultView<Boolean> set(@PathParam(value="key") String key, SetKvTTLRequest request) {
        this.kvStoreService.setTTL(KEYSPACE_WEB_SESSION_PRIVATE, this.toPrivateKey(key), request.getTtl(), ServerManager.getInstance().getServerIfNullDefault(request.getServerId()));
        return CommonResultView.success(true);
    }

    @GET
    @Path(value="/{keys}/:bulk")
    @Consumes(value={"application/json"})
    public CommonResultView<List<KeyValueData>> getBulk(@PathParam(value="keys") String keyBySeparator, @QueryParam(value="serverId") int serverId) {
        List<KeyValueData> resultList = this.kvStoreService.getBulk(KEYSPACE_WEB_SESSION_PRIVATE, ZZ.splitParam(keyBySeparator).stream().map(this::toPrivateKey).collect(Collectors.toList()), ServerManager.getInstance().getServerIfNullDefault(serverId));
        List keyGeneralizedList = resultList.stream().peek(d -> d.setKey(this.toGeneralKey(d.getKey()))).collect(Collectors.toList());
        return CommonResultView.success(keyGeneralizedList);
    }

    @PUT
    @Path(value="/:bulk")
    @Consumes(value={"application/json"})
    public CommonResultView<List<KeyValueData>> setBulk(SetKvBulkRequest request) {
        List<KeyValueData> resultList = this.kvStoreService.setBulk(KEYSPACE_WEB_SESSION_PRIVATE, request.toMapPadKeyPrefix(this.getPrivateKeyPrefix()), request.getTtl(), ServerManager.getInstance().getServerIfNullDefault(request.getServerId()));
        List keyGeneralizedList = resultList.stream().peek(d -> d.setKey(this.toGeneralKey(d.getKey()))).collect(Collectors.toList());
        return CommonResultView.success(keyGeneralizedList);
    }

    private String getPrivateKeyPrefix() {
        UserToken userToken = WebRequestContext.getUserToken();
        if (userToken == null) {
            ErrorState.LOGIN_REQUIRED.newBizException();
        }
        return "]" + userToken.getUserId() + ":";
    }

    private String toPrivateKey(String key) {
        return this.getPrivateKeyPrefix() + key;
    }

    private String toGeneralKey(String key) {
        String prefix = this.getPrivateKeyPrefix();
        if (!StringUtils.startsWith((CharSequence)key, (CharSequence)prefix)) {
            ErrorState.ILLEGAL_KEY_ACCESS.newBizException();
        }
        return StringUtils.substring((String)key, (int)prefix.length());
    }
}

