/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import io.swagger.annotations.Api;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import scouter.util.HashUtil;
import scouter.util.Hexa32;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.layer.service.CustomKvStoreService;
import scouterx.webapp.view.CommonResultView;

@Path(value="/v1/shortener")
@Api(value="ShortenURL")
@Singleton
@Produces(value={"application/json"})
public class ShortenController {
    @Context
    HttpServletRequest servletRequest;
    private final CustomKvStoreService kvStoreService = new CustomKvStoreService();

    @GET
    @Path(value="/{key}")
    public CommonResultView<String> getShortenUrl(@PathParam(value="key") String key, @QueryParam(value="serverId") int serverId) {
        String result = this.kvStoreService.get("shortner", key, ServerManager.getInstance().getServerIfNullDefault(serverId));
        return CommonResultView.success(result);
    }

    @POST
    @Consumes(value={"application/json"})
    public CommonResultView<String> makeShortenUrl(@QueryParam(value="url") String url, @QueryParam(value="serverId") int serverId) {
        String hashed = Hexa32.toString32((long)HashUtil.hash((String)url));
        this.kvStoreService.set("shortner", hashed, url, ServerManager.getInstance().getServerIfNullDefault(serverId));
        String reqUrl = this.servletRequest.getRequestURL().toString();
        String shortenerServiceUrl = reqUrl.substring(0, reqUrl.indexOf(this.servletRequest.getPathInfo()));
        return CommonResultView.success(shortenerServiceUrl + "/s/" + hashed);
    }
}

