/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import scouter.lang.pack.InteractionPerfCounterPack;
import scouterx.webapp.framework.client.model.TextLoader;
import scouterx.webapp.framework.client.model.TextProxy;
import scouterx.webapp.framework.client.model.TextTypeEnum;
import scouterx.webapp.model.scouter.CounterValue;
import scouterx.webapp.model.scouter.SCounter;

public class InteractionCounterData {
    public String objName;
    public String interactionType;
    public int fromObjHash;
    public String fromObjName;
    public List<CounterValue> fromObjCounters = new ArrayList<CounterValue>();
    public int toObjHash;
    public String toObjName;
    public List<CounterValue> toObjCounters = new ArrayList<CounterValue>();
    public int period;
    public int count;
    public int errorCount;
    public long totalElapsed;

    public static InteractionCounterData of(InteractionPerfCounterPack p, int serverId) {
        InteractionCounterData.preLoadDictionary(p, serverId);
        return InteractionCounterData.builder().interactionType(p.interactionType).objName(p.objName).fromObjHash(p.fromHash).fromObjName(TextProxy.object.getCachedTextIfNullDefault(p.fromHash)).toObjHash(p.toHash).toObjName(TextProxy.object.getCachedTextIfNullDefault(p.toHash)).period(p.period).count(p.count).errorCount(p.errorCount).totalElapsed(p.totalElapsed).fromObjCounters(new ArrayList<CounterValue>()).toObjCounters(new ArrayList<CounterValue>()).build();
    }

    private static void preLoadDictionary(InteractionPerfCounterPack pack, int serverId) {
        TextLoader loader = new TextLoader(serverId);
        loader.addTextHash(TextTypeEnum.OBJECT, pack.fromHash);
        loader.addTextHash(TextTypeEnum.OBJECT, pack.toHash);
        loader.loadAll();
    }

    public void addFromObjCounter(SCounter counter) {
        if (counter != null) {
            this.fromObjCounters.add(CounterValue.of(counter));
        }
    }

    public void addToObjCounter(SCounter counter) {
        if (counter != null) {
            this.toObjCounters.add(CounterValue.of(counter));
        }
    }

    @ConstructorProperties(value={"objName", "interactionType", "fromObjHash", "fromObjName", "fromObjCounters", "toObjHash", "toObjName", "toObjCounters", "period", "count", "errorCount", "totalElapsed"})
    InteractionCounterData(String objName, String interactionType, int fromObjHash, String fromObjName, List<CounterValue> fromObjCounters, int toObjHash, String toObjName, List<CounterValue> toObjCounters, int period, int count, int errorCount, long totalElapsed) {
        this.objName = objName;
        this.interactionType = interactionType;
        this.fromObjHash = fromObjHash;
        this.fromObjName = fromObjName;
        this.fromObjCounters = fromObjCounters;
        this.toObjHash = toObjHash;
        this.toObjName = toObjName;
        this.toObjCounters = toObjCounters;
        this.period = period;
        this.count = count;
        this.errorCount = errorCount;
        this.totalElapsed = totalElapsed;
    }

    public static InteractionCounterDataBuilder builder() {
        return new InteractionCounterDataBuilder();
    }

    public String getObjName() {
        return this.objName;
    }

    public String getInteractionType() {
        return this.interactionType;
    }

    public int getFromObjHash() {
        return this.fromObjHash;
    }

    public String getFromObjName() {
        return this.fromObjName;
    }

    public List<CounterValue> getFromObjCounters() {
        return this.fromObjCounters;
    }

    public int getToObjHash() {
        return this.toObjHash;
    }

    public String getToObjName() {
        return this.toObjName;
    }

    public List<CounterValue> getToObjCounters() {
        return this.toObjCounters;
    }

    public int getPeriod() {
        return this.period;
    }

    public int getCount() {
        return this.count;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public long getTotalElapsed() {
        return this.totalElapsed;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }

    public void setInteractionType(String interactionType) {
        this.interactionType = interactionType;
    }

    public void setFromObjHash(int fromObjHash) {
        this.fromObjHash = fromObjHash;
    }

    public void setFromObjName(String fromObjName) {
        this.fromObjName = fromObjName;
    }

    public void setFromObjCounters(List<CounterValue> fromObjCounters) {
        this.fromObjCounters = fromObjCounters;
    }

    public void setToObjHash(int toObjHash) {
        this.toObjHash = toObjHash;
    }

    public void setToObjName(String toObjName) {
        this.toObjName = toObjName;
    }

    public void setToObjCounters(List<CounterValue> toObjCounters) {
        this.toObjCounters = toObjCounters;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public void setTotalElapsed(long totalElapsed) {
        this.totalElapsed = totalElapsed;
    }

    public static class InteractionCounterDataBuilder {
        private String objName;
        private String interactionType;
        private int fromObjHash;
        private String fromObjName;
        private List<CounterValue> fromObjCounters;
        private int toObjHash;
        private String toObjName;
        private List<CounterValue> toObjCounters;
        private int period;
        private int count;
        private int errorCount;
        private long totalElapsed;

        InteractionCounterDataBuilder() {
        }

        public InteractionCounterDataBuilder objName(String objName) {
            this.objName = objName;
            return this;
        }

        public InteractionCounterDataBuilder interactionType(String interactionType) {
            this.interactionType = interactionType;
            return this;
        }

        public InteractionCounterDataBuilder fromObjHash(int fromObjHash) {
            this.fromObjHash = fromObjHash;
            return this;
        }

        public InteractionCounterDataBuilder fromObjName(String fromObjName) {
            this.fromObjName = fromObjName;
            return this;
        }

        public InteractionCounterDataBuilder fromObjCounters(List<CounterValue> fromObjCounters) {
            this.fromObjCounters = fromObjCounters;
            return this;
        }

        public InteractionCounterDataBuilder toObjHash(int toObjHash) {
            this.toObjHash = toObjHash;
            return this;
        }

        public InteractionCounterDataBuilder toObjName(String toObjName) {
            this.toObjName = toObjName;
            return this;
        }

        public InteractionCounterDataBuilder toObjCounters(List<CounterValue> toObjCounters) {
            this.toObjCounters = toObjCounters;
            return this;
        }

        public InteractionCounterDataBuilder period(int period) {
            this.period = period;
            return this;
        }

        public InteractionCounterDataBuilder count(int count) {
            this.count = count;
            return this;
        }

        public InteractionCounterDataBuilder errorCount(int errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        public InteractionCounterDataBuilder totalElapsed(long totalElapsed) {
            this.totalElapsed = totalElapsed;
            return this;
        }

        public InteractionCounterData build() {
            return new InteractionCounterData(this.objName, this.interactionType, this.fromObjHash, this.fromObjName, this.fromObjCounters, this.toObjHash, this.toObjName, this.toObjCounters, this.period, this.count, this.errorCount, this.totalElapsed);
        }

        public String toString() {
            return "InteractionCounterData.InteractionCounterDataBuilder(objName=" + this.objName + ", interactionType=" + this.interactionType + ", fromObjHash=" + this.fromObjHash + ", fromObjName=" + this.fromObjName + ", fromObjCounters=" + this.fromObjCounters + ", toObjHash=" + this.toObjHash + ", toObjName=" + this.toObjName + ", toObjCounters=" + this.toObjCounters + ", period=" + this.period + ", count=" + this.count + ", errorCount=" + this.errorCount + ", totalElapsed=" + this.totalElapsed + ")";
        }
    }
}

