/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model.summary;

import java.util.List;
import scouter.lang.value.ListValue;
import scouter.util.DateTimeHelper;
import scouterx.webapp.framework.client.model.TextProxy;
import scouterx.webapp.framework.dto.DateAndMapPack;
import scouterx.webapp.model.summary.Summary;
import scouterx.webapp.model.summary.SummaryItem;

public class ApiCallSummaryItem
extends SummaryItem<ApiCallSummaryItem> {
    private int errorCount;
    private long elapsedSum;

    public ApiCallSummaryItem(int summaryKey, String summaryKeyName, int count, int errorCount, long elapsedSum) {
        this.summaryKey = summaryKey;
        this.summaryKeyName = summaryKeyName;
        this.count = count;
        this.errorCount = errorCount;
        this.elapsedSum = elapsedSum;
    }

    @Override
    public void merge(ApiCallSummaryItem newItem) {
        this.setCount(this.getCount() + newItem.getCount());
        this.setErrorCount(this.getErrorCount() + newItem.getErrorCount());
        this.setElapsedSum(this.getElapsedSum() + newItem.getElapsedSum());
    }

    @Override
    public Summary<ApiCallSummaryItem> toSummary(List<DateAndMapPack> dnmPackList, int serverId) {
        Summary<ApiCallSummaryItem> summary = new Summary<ApiCallSummaryItem>();
        for (DateAndMapPack dnmPack : dnmPackList) {
            long date = DateTimeHelper.getDefault().yyyymmdd(dnmPack.getYyyymmdd());
            ListValue idList = dnmPack.getMapPack().getList("id");
            ListValue countList = dnmPack.getMapPack().getList("count");
            ListValue errorCntList = dnmPack.getMapPack().getList("error");
            ListValue elapsedSumList = dnmPack.getMapPack().getList("elapsed");
            for (int i = 0; i < idList.size(); ++i) {
                ApiCallSummaryItem item = ApiCallSummaryItem.builder().summaryKey(idList.getInt(i)).summaryKeyName(TextProxy.apicall.getTextIfNullDefault(date, idList.getInt(i), serverId)).count(countList.getInt(i)).errorCount(errorCntList.getInt(i)).elapsedSum(elapsedSumList.getLong(i)).build();
                summary.merge(item);
            }
        }
        return summary;
    }

    public static ApiCallSummaryItemBuilder builder() {
        return new ApiCallSummaryItemBuilder();
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public long getElapsedSum() {
        return this.elapsedSum;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public void setElapsedSum(long elapsedSum) {
        this.elapsedSum = elapsedSum;
    }

    @Override
    public String toString() {
        return "ApiCallSummaryItem(errorCount=" + this.getErrorCount() + ", elapsedSum=" + this.getElapsedSum() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiCallSummaryItem)) {
            return false;
        }
        ApiCallSummaryItem other = (ApiCallSummaryItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getErrorCount() != other.getErrorCount()) {
            return false;
        }
        return this.getElapsedSum() == other.getElapsedSum();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ApiCallSummaryItem;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + this.getErrorCount();
        long $elapsedSum = this.getElapsedSum();
        result = result * 59 + (int)($elapsedSum >>> 32 ^ $elapsedSum);
        return result;
    }

    public ApiCallSummaryItem() {
    }

    public static class ApiCallSummaryItemBuilder {
        private int summaryKey;
        private String summaryKeyName;
        private int count;
        private int errorCount;
        private long elapsedSum;

        ApiCallSummaryItemBuilder() {
        }

        public ApiCallSummaryItemBuilder summaryKey(int summaryKey) {
            this.summaryKey = summaryKey;
            return this;
        }

        public ApiCallSummaryItemBuilder summaryKeyName(String summaryKeyName) {
            this.summaryKeyName = summaryKeyName;
            return this;
        }

        public ApiCallSummaryItemBuilder count(int count) {
            this.count = count;
            return this;
        }

        public ApiCallSummaryItemBuilder errorCount(int errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        public ApiCallSummaryItemBuilder elapsedSum(long elapsedSum) {
            this.elapsedSum = elapsedSum;
            return this;
        }

        public ApiCallSummaryItem build() {
            return new ApiCallSummaryItem(this.summaryKey, this.summaryKeyName, this.count, this.errorCount, this.elapsedSum);
        }

        public String toString() {
            return "ApiCallSummaryItem.ApiCallSummaryItemBuilder(summaryKey=" + this.summaryKey + ", summaryKeyName=" + this.summaryKeyName + ", count=" + this.count + ", errorCount=" + this.errorCount + ", elapsedSum=" + this.elapsedSum + ")";
        }
    }
}

