/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model.summary;

import java.util.List;
import scouter.lang.value.ListValue;
import scouter.util.DateTimeHelper;
import scouter.util.IPUtil;
import scouterx.webapp.framework.dto.DateAndMapPack;
import scouterx.webapp.model.summary.Summary;
import scouterx.webapp.model.summary.SummaryItem;

public class IpSummaryItem
extends SummaryItem<IpSummaryItem> {
    public IpSummaryItem(int summaryKey, String summaryKeyName, int count) {
        this.summaryKey = summaryKey;
        this.summaryKeyName = summaryKeyName;
        this.count = count;
    }

    @Override
    public void merge(IpSummaryItem newItem) {
        this.setCount(this.getCount() + newItem.getCount());
    }

    @Override
    public Summary<IpSummaryItem> toSummary(List<DateAndMapPack> dnmPackList, int serverId) {
        Summary<IpSummaryItem> summary = new Summary<IpSummaryItem>();
        for (DateAndMapPack dnmPack : dnmPackList) {
            long date = DateTimeHelper.getDefault().yyyymmdd(dnmPack.getYyyymmdd());
            ListValue idList = dnmPack.getMapPack().getList("id");
            ListValue countList = dnmPack.getMapPack().getList("count");
            for (int i = 0; i < idList.size(); ++i) {
                IpSummaryItem item = IpSummaryItem.builder().summaryKey(idList.getInt(i)).summaryKeyName(IPUtil.toString((int)idList.getInt(i))).count(countList.getInt(i)).build();
                summary.merge(item);
            }
        }
        return summary;
    }

    public static IpSummaryItemBuilder builder() {
        return new IpSummaryItemBuilder();
    }

    @Override
    public String toString() {
        return "IpSummaryItem()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IpSummaryItem)) {
            return false;
        }
        IpSummaryItem other = (IpSummaryItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IpSummaryItem;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    public IpSummaryItem() {
    }

    public static class IpSummaryItemBuilder {
        private int summaryKey;
        private String summaryKeyName;
        private int count;

        IpSummaryItemBuilder() {
        }

        public IpSummaryItemBuilder summaryKey(int summaryKey) {
            this.summaryKey = summaryKey;
            return this;
        }

        public IpSummaryItemBuilder summaryKeyName(String summaryKeyName) {
            this.summaryKeyName = summaryKeyName;
            return this;
        }

        public IpSummaryItemBuilder count(int count) {
            this.count = count;
            return this;
        }

        public IpSummaryItem build() {
            return new IpSummaryItem(this.summaryKey, this.summaryKeyName, this.count);
        }

        public String toString() {
            return "IpSummaryItem.IpSummaryItemBuilder(summaryKey=" + this.summaryKey + ", summaryKeyName=" + this.summaryKeyName + ", count=" + this.count + ")";
        }
    }
}

