/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.request;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.exception.ErrorState;

public class VisitorGroupRequest {
    private int serverId;
    @QueryParam(value="startYmd")
    private String startYmd;
    @QueryParam(value="endYmd")
    private String endYmd;
    @QueryParam(value="startYmdH")
    private long startYmdH;
    @QueryParam(value="endYmdH")
    private long endYmdH;
    @PathParam(value="objHashes")
    String objHashes;

    @QueryParam(value="serverId")
    public void setServerId(int serverId) {
        this.serverId = ServerManager.getInstance().getServerIfNullDefault(serverId).getId();
    }

    public void validate() {
        if (StringUtils.isNotBlank((CharSequence)this.startYmd) || StringUtils.isNotBlank((CharSequence)this.endYmd)) {
            if (StringUtils.isBlank((CharSequence)this.startYmd) || StringUtils.isBlank((CharSequence)this.endYmd)) {
                throw ErrorState.VALIDATE_ERROR.newBizException("startYmd and endYmd should be not null !");
            }
            if (this.startYmdH > 0L || this.endYmdH > 0L) {
                throw ErrorState.VALIDATE_ERROR.newBizException("startYmd, endYmd and startYmdH, endYmdH must not coexist!");
            }
            this.setTimeAsYmd();
        } else if (this.startYmdH <= 0L || this.endYmdH <= 0L) {
            throw ErrorState.VALIDATE_ERROR.newBizException("startYmdH and endYmdH must have value!");
        }
    }

    private void setTimeAsYmd() {
        ZoneId zoneId = ZoneId.systemDefault();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHH");
        LocalDateTime startDateTime = LocalDateTime.parse(this.startYmd, formatter);
        LocalDateTime endDateTime = LocalDateTime.parse(this.endYmd, formatter);
        this.startYmdH = startDateTime.atZone(zoneId).toEpochSecond() * 1000L;
        this.endYmdH = endDateTime.atZone(zoneId).toEpochSecond() * 1000L;
    }

    public int getServerId() {
        return this.serverId;
    }

    public String getStartYmd() {
        return this.startYmd;
    }

    public String getEndYmd() {
        return this.endYmd;
    }

    public long getStartYmdH() {
        return this.startYmdH;
    }

    public long getEndYmdH() {
        return this.endYmdH;
    }

    public String getObjHashes() {
        return this.objHashes;
    }

    public void setStartYmd(String startYmd) {
        this.startYmd = startYmd;
    }

    public void setEndYmd(String endYmd) {
        this.endYmd = endYmd;
    }

    public void setStartYmdH(long startYmdH) {
        this.startYmdH = startYmdH;
    }

    public void setEndYmdH(long endYmdH) {
        this.endYmdH = endYmdH;
    }

    public void setObjHashes(String objHashes) {
        this.objHashes = objHashes;
    }

    public String toString() {
        return "VisitorGroupRequest(serverId=" + this.getServerId() + ", startYmd=" + this.getStartYmd() + ", endYmd=" + this.getEndYmd() + ", startYmdH=" + this.getStartYmdH() + ", endYmdH=" + this.getEndYmdH() + ", objHashes=" + this.getObjHashes() + ")";
    }
}

