/*
 * Decompiled with CFR 0.152.
 */
package scouter.xtra.tools;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.util.Properties;

public class JVM {
    private String pid;
    private VirtualMachine vm = null;
    private String desc;

    public JVM(String pid) {
        this.pid = pid;
    }

    public boolean isConnected() {
        return this.vm != null;
    }

    public String getPid() {
        return this.pid;
    }

    public boolean connect() throws AttachNotSupportedException, IOException {
        this.vm = VirtualMachine.attach(this.pid);
        this.desc = this.vm.getSystemProperties().getProperty("sun.java.command");
        return true;
    }

    public void close() {
        if (this.vm != null) {
            try {
                this.vm.detach();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.pid = null;
        this.vm = null;
    }

    public Properties getSystemProperties() throws IOException {
        if (this.vm == null) {
            throw new RuntimeException("Not connected to jvm");
        }
        return this.vm.getSystemProperties();
    }

    public VirtualMachine getVM() {
        return this.vm;
    }

    public String getDesc() {
        return this.desc;
    }
}

