/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import scouter.agent.batch.Logger;
import scouter.agent.batch.util.JarUtil;
import scouter.lang.conf.ConfigDesc;
import scouter.lang.conf.ConfigValueType;
import scouter.lang.conf.ConfigValueUtil;
import scouter.lang.conf.ValueType;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.util.FileUtil;
import scouter.util.HashUtil;
import scouter.util.StringEnumer;
import scouter.util.StringKeyLinkedMap;
import scouter.util.StringSet;
import scouter.util.StringUtil;
import scouter.util.SysJMX;
import scouter.util.SystemUtil;

public class Configure {
    public static final String CONFIG_SCOUTER_ENABLED = "scouter_enabled";
    public static final String VM_SCOUTER_ENABLED = "scouter.enabled";
    public static boolean JDBC_REDEFINED = false;
    private static Configure instance = null;
    public Properties property = new Properties();
    private File propertyFile;
    public static String agent_dir_path;
    @ConfigDesc(value="Enable scouter monitor")
    public boolean scouter_enabled = true;
    public boolean scouter_stop = false;
    @ConfigDesc(value="Standalone mode")
    public boolean scouter_standalone = false;
    @ConfigDesc(value="Batch ID type(class,args, props)")
    public String batch_id_type = "class";
    @ConfigDesc(value="Batch ID(args-index number, props-key string)")
    public String batch_id = "";
    @ConfigDesc(value="Collect sql statistics")
    public boolean sql_enabled = true;
    @ConfigDesc(value="SQL max count")
    public int sql_max_count = 100;
    @ConfigDesc(value="Method set for preparestatement hooking")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_jdbc_pstmt_classes = "";
    @ConfigDesc(value="Method set for statement hooking")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_jdbc_stmt_classes = "";
    @ConfigDesc(value="Method set for resultset hooking")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String hook_jdbc_rs_classes = "";
    @ConfigDesc(value="Stack dump collector")
    public boolean sfa_dump_enabled = true;
    @ConfigDesc(value="Stack dump interval(ms)")
    public int sfa_dump_interval_ms = 10000;
    @ConfigDesc(value="Stack dump filter(,)")
    public String[] sfa_dump_filter = null;
    @ConfigDesc(value="Stack dump directory")
    public File sfa_dump_dir = new File(agent_dir_path + "/dump");
    @ConfigDesc(value="Add Stack dump header")
    public boolean sfa_dump_header_exists = true;
    @ConfigDesc(value="Batch elapsed time(millisecond) to send SFA dump file to scouter server")
    public long sfa_dump_send_elapsed_ms = 30000L;
    @ConfigDesc(value="Batch elapsed time(millisecond) to send batch log to scouter server")
    public long batch_log_send_elapsed_ms = 30000L;
    @ConfigDesc(value="Thread check interval time(millisecond)")
    public long thread_check_interval_ms = 1000L;
    @ConfigDesc(value="Collector IP")
    public String net_collector_ip = "127.0.0.1";
    @ConfigDesc(value="Collector UDP Port")
    public int net_collector_udp_port = 6100;
    @ConfigDesc(value="Collector TCP Port")
    public int net_collector_tcp_port = 6100;
    @ConfigDesc(value="Collector TCP Session Count")
    public int net_collector_tcp_session_count = 1;
    @ConfigDesc(value="Collector TCP Socket Timeout(ms)")
    public int net_collector_tcp_so_timeout_ms = 60000;
    @ConfigDesc(value="Collector TCP Connection Timeout(ms)")
    public int net_collector_tcp_connection_timeout_ms = 3000;
    @ConfigDesc(value="Local UDP Port")
    public int net_local_udp_port = 6101;
    @ConfigDesc(value="UDP Buffer Size")
    public int net_udp_packet_max_bytes = 60000;
    @ConfigDesc(value="UDP Collection Interval(ms)")
    public long net_udp_collection_interval_ms = 100L;
    @ConfigDesc(value="Stack Log TCP Session Count")
    public int net_tcp_stack_session_count = 1;
    @ConfigDesc(value="Object Type")
    public String obj_type = "batch";
    @ConfigDesc(value="Object Name")
    public String obj_name = "";
    @ConfigDesc(value="Host Type")
    public String obj_host_type = "";
    @ConfigDesc(value="Host Name")
    public String obj_host_name = "";
    @ConfigDesc(value="Activating for using object name as PID")
    public boolean obj_name_auto_pid_enabled = false;
    @ConfigDesc(value="Redefining DS, RP type according to main object")
    public boolean obj_type_inherit_to_child_enabled = false;
    @ConfigDesc(value="Plugin directory")
    public File plugin_dir = new File(agent_dir_path + "/plugin");
    @ConfigDesc(value="")
    public boolean _log_asm_enabled;
    @ConfigDesc(value="Log directory")
    public String log_dir = "";
    @ConfigDesc(value="Retaining log according to date")
    public boolean log_rotation_enabled = true;
    @ConfigDesc(value="Keeping period of log")
    public int log_keep_days = 7;
    @ConfigDesc(value="Leave sbr log even when not in standalone mode")
    public boolean sbr_log_make = false;
    @ConfigDesc(value="")
    public boolean _trace = false;
    @ConfigDesc(value="")
    public boolean _trace_use_logger = false;
    private int objHash;
    private String objName;
    private int objHostHash;
    private String objHostName;
    private StringSet log_ignore_set = new StringSet();
    private static HashSet<String> ignoreSet;

    public static final synchronized Configure getInstance() {
        if (instance == null) {
            instance = new Configure();
        }
        return instance;
    }

    private Configure() {
        Properties p = new Properties();
        HashMap<Object, Object> args = new HashMap<Object, Object>();
        args.putAll(System.getenv());
        args.putAll(System.getProperties());
        p.putAll((Map<?, ?>)args);
        this.property = p;
        this.reload();
    }

    private Configure(boolean b) {
    }

    public File getPropertyFile() {
        if (this.propertyFile != null) {
            return this.propertyFile;
        }
        String s = System.getProperty("scouter.config", agent_dir_path + "/conf/scouter.batch.conf");
        this.propertyFile = new File(s.trim());
        return this.propertyFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        File file = this.getPropertyFile();
        Properties temp = new Properties();
        if (file.canRead()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                temp.load(in);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    FileUtil.close(in);
                    throw throwable;
                }
                FileUtil.close(in);
            }
            FileUtil.close(in);
        }
        this.property = ConfigValueUtil.replaceSysProp(temp);
        this.apply();
        Logger.println("scouter_enabled=" + this.scouter_enabled);
        Logger.println("scouter_standalone=" + this.scouter_standalone);
        Logger.println("sql_enabled=" + this.sql_enabled);
        Logger.println("sfa_dump_enabled=" + this.sql_enabled);
        if (this.sfa_dump_enabled) {
            Logger.println("sfa_dump_dir=" + this.sfa_dump_dir.getAbsolutePath());
        }
    }

    private void apply() {
        String[] arrs;
        String value;
        this.scouter_enabled = this.getBoolean(CONFIG_SCOUTER_ENABLED, true);
        if (this.getValue(VM_SCOUTER_ENABLED) != null) {
            this.scouter_enabled = this.getBoolean(VM_SCOUTER_ENABLED, true);
        }
        this.scouter_standalone = this.getBoolean("scouter_standalone", true);
        this.batch_id_type = this.getValue("batch_id_type", "class");
        if ("class".equals(this.batch_id_type)) {
            this.batch_id = this.getValue("batch_id", "");
        } else if ("args".equals(this.batch_id_type)) {
            this.batch_id = this.getValue("batch_id", "0");
        } else if ("props".equals(this.batch_id_type)) {
            this.batch_id = this.getValue("batch_id", "JobId");
        }
        this.sql_max_count = this.getInt("sql_max_count", 100);
        this.sfa_dump_interval_ms = this.getInt("sfa_dump_interval_ms", 10000);
        if (this.sfa_dump_interval_ms < 5000) {
            this.sfa_dump_interval_ms = 5000;
        }
        if ((value = this.getValue("sfa_dump_filter")) != null && (arrs = StringUtil.split(value, ',')) != null && arrs.length > 0) {
            ArrayList<String> lists = new ArrayList<String>();
            for (String line : arrs) {
                if ((line = line.trim()).length() == 0) continue;
                lists.add(line);
            }
            if (lists.size() > 0) {
                this.sfa_dump_filter = new String[lists.size()];
                for (int i = 0; i < lists.size(); ++i) {
                    this.sfa_dump_filter[i] = (String)lists.get(i);
                }
            }
        }
        this.sfa_dump_enabled = this.getBoolean("sfa_dump_enabled", true);
        if (this.sfa_dump_enabled) {
            value = this.getValue("sfa_dump_dir", agent_dir_path + "/dump");
            File dir = new File(value);
            if (!dir.exists()) {
                try {
                    dir.mkdirs();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (dir.isFile()) {
                this.sfa_dump_enabled = false;
                System.err.println("sfa_dump_dir(" + dir.getAbsolutePath() + ") is file");
            }
            if (!dir.canWrite()) {
                this.sfa_dump_enabled = false;
                System.err.println("sfa_dump_dir(" + dir.getAbsolutePath() + ") can't write");
            }
            this.sfa_dump_dir = dir;
            this.sfa_dump_header_exists = this.getBoolean("sfa_dump_header_exists", true);
        }
        this.sfa_dump_send_elapsed_ms = this.getLong("sfa_dump_send_elapsed_ms", 30000L);
        this.batch_log_send_elapsed_ms = this.getLong("batch_log_send_elapsed_ms", 30000L);
        this.thread_check_interval_ms = this.getLong("thread_check_interval_ms", 1000L);
        this.plugin_dir = new File(this.getValue("plugin_dir", agent_dir_path + "/plugin"));
        this.net_udp_packet_max_bytes = this.getInt("net_udp_packet_max_bytes", 60000);
        this.net_collector_ip = this.getValue("net_collector_ip", "127.0.0.1");
        this.net_collector_udp_port = this.getInt("net_collector_udp_port", 6100);
        this.net_collector_tcp_port = this.getInt("net_collector_tcp_port", 6100);
        this.net_collector_tcp_session_count = this.getInt("net_collector_tcp_session_count", 1, 1);
        this.net_collector_tcp_connection_timeout_ms = this.getInt("net_collector_tcp_connection_timeout_ms", 3000);
        this.net_collector_tcp_so_timeout_ms = this.getInt("net_collector_tcp_so_timeout_ms", 60000);
        this.net_local_udp_port = this.getInt("net_local_udp_port", 6101);
        this.net_tcp_stack_session_count = this.getInt("net_tcp_stack_session_count", 1, 1);
        this.sql_enabled = this.getBoolean("sql_enabled", true);
        this.hook_jdbc_pstmt_classes = this.getValue("hook_jdbc_pstmt_classes", "");
        this.hook_jdbc_stmt_classes = this.getValue("hook_jdbc_stmt_classes", "");
        this.hook_jdbc_rs_classes = this.getValue("hook_jdbc_rs_classes", "");
        this.net_udp_collection_interval_ms = this.getInt("net_udp_collection_interval_ms", 100);
        this._log_asm_enabled = this.getBoolean("_log_asm_enabled", false);
        this.obj_type_inherit_to_child_enabled = this.getBoolean("obj_type_inherit_to_child_enabled", false);
        this.log_dir = this.getValue("log_dir", ".");
        this.log_rotation_enabled = this.getBoolean("log_rotation_enabled", true);
        this.log_keep_days = this.getInt("log_keep_days", 7, 1);
        this.sbr_log_make = this.getBoolean("sbr_log_make", false);
        this._trace = this.getBoolean("_trace", false);
        this._trace_use_logger = this.getBoolean("_trace_use_logger", false);
        this.log_ignore_set = this.getStringSet("mgr_log_ignore_ids", ",");
        this.resetObjInfo();
    }

    public int getObjHash() {
        return this.objHash;
    }

    public String getObjName() {
        return this.objName;
    }

    public int getObjHostHash() {
        return this.objHostHash;
    }

    public String getObjHostName() {
        return this.objHostName;
    }

    public boolean isIgnoreLog(String id) {
        return this.log_ignore_set.hasKey(id);
    }

    public synchronized void resetObjInfo() {
        this.obj_type = this.getValue("obj_type", "batch");
        String detected = "host";
        if (SystemUtil.IS_LINUX) {
            detected = "linux";
        } else if (SystemUtil.IS_WINDOWS) {
            detected = "windows";
        } else if (SystemUtil.IS_MAC_OSX) {
            detected = "osx";
        } else if (SystemUtil.IS_AIX) {
            detected = "aix";
        } else if (SystemUtil.IS_HP_UX) {
            detected = "hpux";
        }
        this.obj_host_type = this.getValue("obj_host_type", detected);
        this.obj_host_name = this.getValue("obj_host_name", SysJMX.getHostName());
        this.objHostName = "/" + this.obj_host_name;
        this.objHostHash = HashUtil.hash(this.objHostName);
        this.obj_name_auto_pid_enabled = this.getBoolean("obj_name_auto_pid_enabled", false);
        this.obj_name = this.getValue("obj_name", "batch");
        this.objName = this.objHostName + "/" + this.obj_name;
        try {
            this.objHash = HashUtil.hash(this.objName.getBytes("UTF-8"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.setProperty("scouter.objname", this.objName);
        System.setProperty("scouter.objtype", this.obj_type);
        System.setProperty("scouter.dir", agent_dir_path);
    }

    private StringSet getStringSet(String key, String deli) {
        StringSet set = new StringSet();
        String v = this.getValue(key);
        if (v != null) {
            String[] vv;
            for (String x : vv = StringUtil.split(v, deli)) {
                if ((x = StringUtil.trimToEmpty(x)).length() <= 0) continue;
                set.put(x);
            }
        }
        return set;
    }

    public String getValue(String key) {
        return StringUtil.trim(this.property.getProperty(key));
    }

    public String getValue(String key, String def) {
        return StringUtil.trim(this.property.getProperty(key, def));
    }

    public int getInt(String key, int def) {
        try {
            String v = this.getValue(key);
            if (v != null) {
                return Integer.parseInt(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    public int getInt(String key, int def, int min) {
        try {
            String v = this.getValue(key);
            if (v != null) {
                return Math.max(Integer.parseInt(v), min);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Math.max(def, min);
    }

    public long getLong(String key, long def) {
        try {
            String v = this.getValue(key);
            if (v != null) {
                return Long.parseLong(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    public boolean getBoolean(String key, boolean def) {
        try {
            String v = this.getValue(key);
            if (v != null) {
                return Boolean.parseBoolean(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String loadText() {
        String string;
        File file = this.getPropertyFile();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            byte[] buff = FileUtil.readAll(fin);
            string = new String(buff);
        }
        catch (Exception exception) {
            FileUtil.close(fin);
            return null;
        }
        catch (Throwable throwable) {
            FileUtil.close(fin);
            throw throwable;
        }
        FileUtil.close(fin);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public boolean saveText(String text) {
        boolean bl;
        File file = this.getPropertyFile();
        FileOutputStream out = null;
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            out = new FileOutputStream(file);
            ((OutputStream)out).write(text.getBytes());
            bl = true;
        }
        catch (Exception exception) {
            FileUtil.close(out);
            catch (Throwable throwable) {
                FileUtil.close(out);
                throw throwable;
            }
        }
        FileUtil.close(out);
        return bl;
        return false;
    }

    public void printConfig() {
        Logger.info("Configure -Dscouter.config=" + this.propertyFile);
    }

    public MapValue getKeyValueInfo() {
        StringKeyLinkedMap<Object> defMap = ConfigValueUtil.getConfigDefault(new Configure(true));
        StringKeyLinkedMap<Object> curMap = ConfigValueUtil.getConfigDefault(this);
        MapValue m = new MapValue();
        ListValue nameList = m.newList("key");
        ListValue valueList = m.newList("value");
        ListValue defList = m.newList("default");
        StringEnumer enu = defMap.keys();
        while (enu.hasMoreElements()) {
            String key = enu.nextString();
            if (ignoreSet.contains(key)) continue;
            nameList.add(key);
            valueList.add(ConfigValueUtil.toValue(curMap.get(key)));
            defList.add(ConfigValueUtil.toValue(defMap.get(key)));
        }
        return m;
    }

    public StringKeyLinkedMap<String> getConfigureDesc() {
        return ConfigValueUtil.getConfigDescMap(this);
    }

    public StringKeyLinkedMap<ValueType> getConfigureValueType() {
        return ConfigValueUtil.getConfigValueTypeMap(this);
    }

    static {
        File jarFile = JarUtil.getThisJarFile();
        agent_dir_path = jarFile != null ? jarFile.getParent() : new File(".").getAbsolutePath();
        ignoreSet = new HashSet();
        ignoreSet.add("property");
        ignoreSet.add("__experimental");
    }
}

