/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.asm;

import java.util.HashSet;
import scouter.agent.batch.ClassDesc;
import scouter.agent.batch.Configure;
import scouter.agent.batch.Logger;
import scouter.agent.batch.asm.IASM;
import scouter.agent.batch.asm.PreparedStatementCV;
import scouter.agent.batch.asm.util.HookingSet;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;

public class JDBCPreparedStatementASM
implements IASM,
Opcodes {
    public final HashSet<String> target;
    public final HashSet<String> noField;

    public JDBCPreparedStatementASM() {
        this.target = HookingSet.getHookingClassSet(Configure.getInstance().hook_jdbc_pstmt_classes);
        this.noField = new HashSet();
        this.target.add("oracle/jdbc/driver/OraclePreparedStatement");
        this.target.add("org/mariadb/jdbc/MySQLPreparedStatement");
        this.target.add("org/mariadb/jdbc/AbstractPrepareStatement");
        this.target.add("org/mariadb/jdbc/AbstractMariaDbPrepareStatement");
        this.target.add("org/mariadb/jdbc/MariaDbClientPreparedStatement");
        this.target.add("org/mariadb/jdbc/MariaDbServerPreparedStatement");
        this.target.add("org/mariadb/jdbc/MariaDbPreparedStatementClient");
        this.target.add("org/mariadb/jdbc/MariaDbPreparedStatementServer");
        this.target.add("org/mariadb/jdbc/ClientSidePreparedStatement");
        this.target.add("org/mariadb/jdbc/ServerSidePreparedStatement");
        this.target.add("org/postgresql/jdbc2/AbstractJdbc2Statement");
        this.target.add("org/postgresql/jdbc/PgPreparedStatement");
        this.target.add("org/apache/derby/client/am/PreparedStatement");
        this.target.add("net/sourceforge/jtds/jdbc/JtdsPreparedStatement");
        this.target.add("jdbc/FakePreparedStatement");
        this.target.add("jdbc/FakePreparedStatement2");
        this.target.add("com/microsoft/sqlserver/jdbc/SQLServerPreparedStatement");
        this.target.add("com/tmax/tibero/jdbc/TbPreparedStatement");
        this.target.add("com/tmax/tibero/jdbc/driver/TbPreparedStatement");
        this.target.add("org/hsqldb/jdbc/JDBCPreparedStatement");
        this.target.add("com/mysql/jdbc/ServerPreparedStatement");
        this.target.add("com/mysql/jdbc/PreparedStatement");
        this.target.add("com/mysql/cj/jdbc/ServerPreparedStatement");
        this.target.add("cubrid/jdbc/driver/CUBRIDPreparedStatement");
        this.target.add("Altibase/jdbc/driver/AltibasePreparedStatement");
        this.target.add("Altibase/jdbc/driver/ABPreparedStatement");
        this.target.add("com/mysql/cj/jdbc/PreparedStatement");
        this.target.add("com/mysql/cj/jdbc/ServerPreparedStatement");
        this.target.add("com/mysql/cj/jdbc/ClientPreparedStatement");
        this.target.add("org/h2/jdbc/JdbcPreparedStatement");
        this.noField.add("com/mysql/jdbc/ServerPreparedStatement");
        this.noField.add("jdbc/FakePreparedStatement2");
        this.noField.add("org/mariadb/jdbc/MariaDbClientPreparedStatement");
        this.noField.add("org/mariadb/jdbc/MariaDbServerPreparedStatement");
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!Configure.getInstance().sql_enabled) {
            return cv;
        }
        if (!this.target.contains(className)) {
            return cv;
        }
        Logger.println("A106", "jdbc pstmt found: " + className);
        return new PreparedStatementCV(cv, this.noField);
    }
}

