/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.asm.jdbc;

import java.util.HashSet;
import java.util.Set;
import scouter.agent.batch.trace.TraceSQL;
import scouter.org.objectweb.asm.Label;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.org.objectweb.asm.Type;
import scouter.org.objectweb.asm.commons.LocalVariablesSorter;

public class PsExecuteMV
extends LocalVariablesSorter
implements Opcodes {
    private static Set<String> target = new HashSet<String>();
    private static final String TRACESQL;
    private static final String START_METHOD = "start";
    private static final String START_SIGNATURE = "()V";
    private static final String END_METHOD = "end";
    private static final String END_SIGNATURE = "()V";
    private static final String ADD_METHOD = "addRow";
    private static final String ADD_SIGNATURE = "(I)V";
    private static final String ADDS_METHOD = "addRows";
    private static final String ADDS_SIGNATURE = "([I)V";
    private Label startFinally = new Label();
    private String owner;
    private final Type returnType;

    public static boolean isTarget(String name) {
        return target.contains(name);
    }

    public PsExecuteMV(int access, String desc, MethodVisitor mv, String owner, String name) {
        super(327680, access, desc, mv);
        this.owner = owner;
        this.returnType = Type.getReturnType(desc);
    }

    @Override
    public void visitCode() {
        this.mv.visitVarInsn(25, 0);
        this.mv.visitVarInsn(25, 0);
        this.mv.visitFieldInsn(180, this.owner, "_current_trace_sql_", "Lscouter/agent/batch/trace/TraceSQL;");
        this.mv.visitMethodInsn(182, TRACESQL, START_METHOD, "()V", false);
        this.mv.visitLabel(this.startFinally);
        this.mv.visitCode();
    }

    @Override
    public void visitInsn(int opcode) {
        if (opcode >= 172 && opcode <= 177) {
            switch (this.returnType.getSort()) {
                case 9: {
                    if (this.returnType.getElementType().getSort() != 5) break;
                    int lvPosReturn = this.newLocal(this.returnType);
                    this.mv.visitVarInsn(58, lvPosReturn);
                    this.mv.visitVarInsn(25, lvPosReturn);
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitFieldInsn(180, this.owner, "_current_trace_sql_", "Lscouter/agent/batch/trace/TraceSQL;");
                    this.mv.visitVarInsn(25, lvPosReturn);
                    this.mv.visitMethodInsn(182, TRACESQL, ADDS_METHOD, ADDS_SIGNATURE, false);
                    break;
                }
                case 5: {
                    int lvPosReturn = this.newLocal(this.returnType);
                    this.mv.visitVarInsn(54, lvPosReturn);
                    this.mv.visitVarInsn(21, lvPosReturn);
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitFieldInsn(180, this.owner, "_current_trace_sql_", "Lscouter/agent/batch/trace/TraceSQL;");
                    this.mv.visitVarInsn(21, lvPosReturn);
                    this.mv.visitMethodInsn(182, TRACESQL, ADD_METHOD, ADD_SIGNATURE, false);
                    break;
                }
            }
            this.mv.visitVarInsn(25, 0);
            this.mv.visitFieldInsn(180, this.owner, "_current_trace_sql_", "Lscouter/agent/batch/trace/TraceSQL;");
            this.mv.visitMethodInsn(182, TRACESQL, END_METHOD, "()V", false);
        }
        this.mv.visitInsn(opcode);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        Label endFinally = new Label();
        this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
        this.mv.visitLabel(endFinally);
        this.mv.visitVarInsn(25, 0);
        this.mv.visitVarInsn(25, 0);
        this.mv.visitFieldInsn(180, this.owner, "_current_trace_sql_", "Lscouter/agent/batch/trace/TraceSQL;");
        this.mv.visitMethodInsn(182, TRACESQL, END_METHOD, "()V", false);
        int errIdx = this.newLocal(Type.getType(Throwable.class));
        this.mv.visitVarInsn(58, errIdx);
        this.mv.visitInsn(191);
        this.mv.visitMaxs(maxStack + 8, maxLocals + 2);
    }

    public static void main(String[] args) {
        Type type = Type.getReturnType("(Z)[I");
        System.out.println("type = " + type.getSort());
        System.out.println("dim = " + type.getDimensions());
        System.out.println("element = " + type.getElementType());
    }

    static {
        target.add("execute");
        target.add("executeQuery");
        target.add("executeUpdate");
        target.add("executeBatch");
        TRACESQL = TraceSQL.class.getName().replace('.', '/');
    }
}

