/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.asm.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import scouter.util.StrMatch;
import scouter.util.StringUtil;

public class HookingSet {
    public byte xType = 0;
    public StrMatch classMatch = null;
    protected Map<String, Object> inner = new HashMap<String, Object>();
    private boolean all_flag = false;
    private int all_flag_value;

    public boolean isA(String method, String desc) {
        if (this.all_flag) {
            return true;
        }
        if (this.contains(method)) {
            return true;
        }
        return this.contains(method + desc);
    }

    public boolean contains(String name) {
        return this.inner.containsKey(name);
    }

    public void add(String mname) {
        if ("*".equals(mname)) {
            this.all_flag = true;
        } else {
            this.inner.put(mname, "");
        }
    }

    public void add(String mname, int idx) {
        if ("*".equals(mname)) {
            this.all_flag = true;
            this.all_flag_value = idx;
        } else {
            this.inner.put(mname, idx);
        }
    }

    public int get(String method, String desc) {
        if (this.all_flag) {
            return this.all_flag_value;
        }
        Integer i = (Integer)this.inner.get(method);
        if (i != null) {
            return i;
        }
        i = (Integer)this.inner.get(method);
        if (i != null) {
            return i;
        }
        return -1;
    }

    public static Map<String, HookingSet> getHookingSet(String arg) {
        String[] c = StringUtil.split(arg, ',');
        HashMap<String, HookingSet> classMap = new HashMap<String, HookingSet>();
        for (int i = 0; i < c.length; ++i) {
            String s = c[i];
            int x = s.lastIndexOf(".");
            if (x <= 0) continue;
            String cname = s.substring(0, x).replace('.', '/');
            String mname = s.substring(x + 1);
            HookingSet methodSet = (HookingSet)classMap.get(cname);
            if (methodSet == null) {
                methodSet = new HookingSet();
                classMap.put(cname, methodSet);
            }
            methodSet.add(mname);
        }
        return classMap;
    }

    public static List<HookingSet> getHookingMethodSet(String patterns) {
        String[] methodPatterns = StringUtil.split(patterns, ',');
        HashMap<String, HookingSet> classMap = new HashMap<String, HookingSet>();
        for (int i = 0; i < methodPatterns.length; ++i) {
            String pattern = methodPatterns[i];
            int dotPos = pattern.lastIndexOf(".");
            if (dotPos <= 0) continue;
            String cname = pattern.substring(0, dotPos).replace('.', '/').trim();
            String mname = pattern.substring(dotPos + 1).trim();
            HookingSet methodSet = (HookingSet)classMap.get(cname);
            if (methodSet == null) {
                methodSet = new HookingSet();
                classMap.put(cname, methodSet);
            }
            methodSet.add(mname);
        }
        ArrayList<HookingSet> list = new ArrayList<HookingSet>();
        for (Map.Entry e : classMap.entrySet()) {
            ((HookingSet)e.getValue()).classMatch = new StrMatch((String)e.getKey());
            list.add((HookingSet)e.getValue());
        }
        return list;
    }

    public static void setHookingMethod(Map<String, HookingSet> classSet, String cname, String mname) {
        HookingSet methodSet = classSet.get(cname);
        if (methodSet == null) {
            methodSet = new HookingSet();
            classSet.put(cname, methodSet);
        }
        methodSet.add(mname);
    }

    public static void add(List<HookingSet> list, String classname, String method) {
        HookingSet.add(list, classname, method, (byte)0);
    }

    public static void add(List<HookingSet> list, String classname, String method, byte serviceType) {
        for (int i = 0; i < list.size(); ++i) {
            HookingSet m = list.get(i);
            if (!m.classMatch.include(classname)) continue;
            m.add(method);
            return;
        }
        HookingSet m = new HookingSet();
        m.xType = serviceType;
        m.classMatch = new StrMatch(classname);
        m.add(method);
        list.add(m);
    }

    public static HashSet<String> getHookingClassSet(String arg) {
        String[] c = StringUtil.tokenizer(arg, ",");
        HashSet<String> classSet = new HashSet<String>();
        if (c == null) {
            return classSet;
        }
        for (int i = 0; i < c.length; ++i) {
            classSet.add(c[i].replace('.', '/').trim());
        }
        return classSet;
    }

    public static Map<String, String> getClassFieldSet(String arg) {
        String[] c = StringUtil.split(arg, ',');
        HashMap<String, String> m = new HashMap<String, String>();
        for (int i = 0; i < c.length; ++i) {
            String s = c[i];
            int x = s.lastIndexOf(".");
            if (x <= 0) continue;
            String cname = s.substring(0, x).replace('.', '/').trim();
            String mname = s.substring(x + 1).trim();
            m.put(cname, mname);
        }
        return m;
    }

    public static Set<String> getClassSet(String arg) {
        String[] c = StringUtil.split(arg, ',');
        HashSet<String> m = new HashSet<String>();
        for (int i = 0; i < c.length; ++i) {
            String s = c[i];
            m.add(s.replace('.', '/'));
        }
        return m;
    }

    public static String buildPatterns(String patterns, List<String> patternsList) {
        for (int i = 0; i < patternsList.size(); ++i) {
            patterns = StringUtil.isNotEmpty(StringUtil.trim(patterns)) ? patterns + "," + patternsList.get(i) : patternsList.get(i);
        }
        return patterns;
    }

    public static String classPattrensToMethodPatterns(String classPatterns, String method) {
        String[] classes = StringUtil.split(classPatterns, ',');
        ArrayList<String> classMethodPatterns = new ArrayList<String>();
        for (int i = 0; i < classes.length; ++i) {
            String s = classes[i];
            classMethodPatterns.add(s + "." + method);
        }
        return HookingSet.buildPatterns("", classMethodPatterns);
    }
}

