/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.netio.data.net;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import scouter.agent.batch.Configure;
import scouter.agent.batch.netio.data.net.TCPStackZipWorker;
import scouter.util.ThreadUtil;

public class TcpAgentReqMgr
extends Thread {
    private static ConcurrentLinkedQueue<byte[]> jobQueue = new ConcurrentLinkedQueue();
    private static List<File> fileList = new ArrayList<File>();
    private static TcpAgentReqMgr instance;
    protected Executor pool;

    public TcpAgentReqMgr() {
        this.pool = ThreadUtil.createExecutor("SCOUTER-REQ-STACK", Configure.getInstance().net_tcp_stack_session_count, 10000, true);
    }

    public static synchronized TcpAgentReqMgr getInstance() {
        if (instance == null) {
            instance = new TcpAgentReqMgr();
            instance.setName("SCOUTER-TCP-REQ-MGR");
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    @Override
    public void run() {
        while (true) {
            int sessionCount = Configure.getInstance().net_tcp_stack_session_count;
            ThreadUtil.sleep(1000L);
            try {
                for (int i = 0; i < sessionCount && TCPStackZipWorker.LIVE.size() < sessionCount; ++i) {
                    TCPStackZipWorker w = new TCPStackZipWorker(this);
                    if (w.prepare(false)) {
                        this.pool.execute(w);
                        continue;
                    }
                    ThreadUtil.sleep(3000L);
                }
                while (TCPStackZipWorker.LIVE.size() > sessionCount) {
                    TCPStackZipWorker w = TCPStackZipWorker.LIVE.removeFirst();
                    w.close(true);
                }
                this.deleteFiles();
            }
            catch (Throwable throwable) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFiles() {
        int size = fileList.size();
        if (size == 0) {
            return;
        }
        List<File> list = fileList;
        synchronized (list) {
            for (int i = size - 1; i >= 0; ++i) {
                if (!fileList.get(i).delete()) continue;
                fileList.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(byte[] job) {
        jobQueue.add(job);
        ConcurrentLinkedQueue<byte[]> concurrentLinkedQueue = jobQueue;
        synchronized (concurrentLinkedQueue) {
            jobQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(File file) {
        List<File> list = fileList;
        synchronized (list) {
            fileList.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getJob() {
        byte[] job = null;
        while ((job = jobQueue.poll()) == null) {
            try {
                ConcurrentLinkedQueue<byte[]> concurrentLinkedQueue = jobQueue;
                synchronized (concurrentLinkedQueue) {
                    jobQueue.wait(3000L);
                }
            }
            catch (Exception exception) {
            }
        }
        return job;
    }
}

