/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.netio.data.net;

import scouter.agent.batch.Configure;
import scouter.agent.batch.netio.data.net.UdpAgent;
import scouter.agent.batch.trace.TraceContext;
import scouter.io.DataOutputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;

public class UdpLocalAgent {
    public static void sendUdpPackToServer(Pack pack) {
        Configure conf = Configure.getInstance();
        try {
            UdpAgent.sendUdpPackToServer(conf.net_collector_ip, conf.net_collector_udp_port, pack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendDumpFileInfo(TraceContext traceContext) {
        Configure conf = Configure.getInstance();
        try {
            DataOutputX out = new DataOutputX();
            out.writeInt(1);
            out.writeLong(traceContext.startTime);
            out.writeText(conf.getObjName());
            out.writeText(traceContext.getLogFullFilename());
            UdpAgent.sendUdp("127.0.0.1", conf.net_local_udp_port, out.toByteArray());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void sendRunningInfo(TraceContext traceContext) {
        MapPack mapPack = traceContext.caculateTemp();
        Configure conf = Configure.getInstance();
        try {
            DataOutputX output = new DataOutputX();
            output.writeInt(4);
            mapPack.write(output);
            UdpAgent.sendUdp("127.0.0.1", conf.net_local_udp_port, output.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendEndInfo(TraceContext traceContext) {
        Configure conf = Configure.getInstance();
        try {
            DataOutputX out = new DataOutputX();
            out.writeInt(3);
            out.writeText(traceContext.batchJobId);
            out.writeInt(traceContext.pID);
            out.writeLong(traceContext.startTime);
            UdpAgent.sendUdp("127.0.0.1", conf.net_local_udp_port, out.toByteArray());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

