/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.netio.data.net;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import scouter.agent.batch.Configure;
import scouter.agent.batch.Logger;
import scouter.agent.batch.Main;
import scouter.agent.batch.netio.data.net.TcpAgentReqMgr;
import scouter.agent.batch.netio.mtu.MultiPacketProcessor;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;

public class UdpLocalServer
extends Thread {
    private static UdpLocalServer instance;
    private int days = 0;
    private int startBatchs = 0;
    private int endBatchs = 0;
    private int endNoSignalBatchs = 0;

    public static synchronized UdpLocalServer getInstance() {
        if (instance == null) {
            instance = new UdpLocalServer();
            instance.setName("SCOUTER-UDP");
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Configure conf = Configure.getInstance();
        byte[] receiveData = new byte[conf.net_udp_packet_max_bytes];
        DatagramSocket serverSocket = null;
        try {
            try {
                serverSocket = new DatagramSocket(conf.net_local_udp_port);
                DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);
                while (true) {
                    serverSocket.receive(receivePacket);
                    int flag = DataInputX.toInt(receiveData, 0);
                    if (flag == 1128351309) {
                        this.processMTU(receiveData, receivePacket.getAddress());
                        continue;
                    }
                    this.process(flag, receiveData);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Throwable throwable) {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw throwable;
        }
    }

    private void processMTU(byte[] receiveData, InetAddress addr) throws Exception {
        DataInputX in = new DataInputX(receiveData);
        in.readInt();
        int objHash = in.readInt();
        long pkid = in.readLong();
        short total = in.readShort();
        short num = in.readShort();
        byte[] data = in.readBlob();
        data = MultiPacketProcessor.getInstance().add(pkid, total, num, data, objHash, addr);
        if (data != null) {
            int flag = DataInputX.toInt(data, 0);
            this.process(flag, data);
        }
    }

    private void process(int flag, byte[] receiveData) throws Exception {
        int size = receiveData.length - 4;
        byte[] data = new byte[size];
        System.arraycopy(receiveData, 4, data, 0, size);
        switch (flag) {
            case 1: {
                TcpAgentReqMgr.getInstance().addJob(data);
                break;
            }
            case 4: {
                this.processRunningInfo(data);
                break;
            }
            case 3: {
                this.processEndInfo(data);
            }
        }
    }

    public int getStartBatchs() {
        return this.startBatchs;
    }

    public int getEndBatchs() {
        return this.endBatchs;
    }

    public int getEndNoSignalBatchs() {
        return this.endNoSignalBatchs;
    }

    public void addEndNoSignalBatchs() {
        this.checkDays();
        ++this.endNoSignalBatchs;
    }

    private void checkDays() {
        int currentDays = (int)(System.currentTimeMillis() / 86400000L);
        if (currentDays != this.days) {
            this.endNoSignalBatchs = 0;
            this.endBatchs = 0;
            this.startBatchs = 0;
            this.days = currentDays;
        }
    }

    private void processRunningInfo(byte[] data) {
        DataInputX input = new DataInputX(data);
        try {
            MapPack mapPack = new MapPack();
            mapPack.read(input);
            String key = new StringBuilder(50).append(mapPack.getText("batchJobId")).append('-').append(mapPack.getLong("pID")).append('-').append(mapPack.getLong("startTime")).toString();
            this.checkDays();
            if (!Main.batchMap.containsKey(key)) {
                ++this.startBatchs;
            }
            Main.batchMap.put(key, mapPack);
        }
        catch (Exception ex) {
            Logger.println("E011", "Exception in processRunningInfo", ex);
            ex.printStackTrace();
        }
    }

    private void processEndInfo(byte[] data) {
        DataInputX input = new DataInputX(data);
        try {
            String key = new StringBuilder(50).append(input.readText()).append('-').append(input.readInt()).append('-').append(input.readLong()).toString();
            this.checkDays();
            ++this.endBatchs;
            Main.batchMap.remove(key);
        }
        catch (Exception ex) {
            Logger.println("E012", "Exception in processEndInfo", ex);
            ex.printStackTrace();
        }
    }
}

