/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.netio.mtu;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;

public class MultiPacket {
    private int added = 0;
    private ArrayList<byte[]> data;
    private long openTime = System.currentTimeMillis();
    private int total;
    private int objHash;
    private InetAddress addr;

    public MultiPacket(int total, int objHash, InetAddress addr) {
        this.total = total;
        this.objHash = objHash;
        this.addr = addr;
        this.data = new ArrayList(total);
        for (int i = 0; i < total; ++i) {
            this.data.add(null);
        }
    }

    public void set(int n, byte[] data) {
        if (n < this.total) {
            if (this.data.get(n) == null) {
                ++this.added;
            }
            this.data.add(n, data);
        }
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.openTime >= 1000L;
    }

    public boolean isDone() {
        return this.total == this.added;
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < this.total; ++i) {
            out.write(this.data.get(i));
        }
        return out.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MultiPacket total=").append(this.total);
        sb.append(" recv=").append(this.added);
        sb.append(" object=(").append(this.objHash).append(")").append(this.objHash);
        sb.append(" ").append(this.addr);
        return sb.toString();
    }
}

