/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.netio.mtu;

import java.io.IOException;
import java.net.InetAddress;
import scouter.agent.batch.netio.mtu.MultiPacket;
import scouter.util.LongEnumer;
import scouter.util.LongKeyLinkedMap;
import scouter.util.ThreadUtil;

public class MultiPacketProcessor
extends Thread {
    private static MultiPacketProcessor instance = null;
    static final int MAX_COUNT = 1000;
    private LongKeyLinkedMap<MultiPacket> buffer = new LongKeyLinkedMap();

    public static MultiPacketProcessor getInstance() {
        if (instance == null) {
            instance = new MultiPacketProcessor();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName(instance));
            instance.start();
        }
        return instance;
    }

    private MultiPacketProcessor() {
        this.buffer.setMax(1000);
    }

    @Override
    public void run() {
        while (true) {
            ThreadUtil.sleep(1000L);
            try {
                if (this.buffer.size() <= 0) continue;
                this.checkExpired();
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] add(long pkid, int total, int num, byte[] data, int objHash, InetAddress addr) throws IOException {
        MultiPacket p;
        LongKeyLinkedMap<MultiPacket> longKeyLinkedMap = this.buffer;
        synchronized (longKeyLinkedMap) {
            p = this.buffer.get(pkid);
            if (p == null) {
                p = new MultiPacket(total, objHash, addr);
                this.buffer.put(pkid, p);
            }
        }
        p.set(num, data);
        if (p.isDone()) {
            this.buffer.remove(pkid);
            return p.toBytes();
        }
        return null;
    }

    private void checkExpired() {
        LongEnumer en = this.buffer.keys();
        while (en.hasMoreElements()) {
            long key = en.nextLong();
            MultiPacket p = this.buffer.get(key);
            if (!p.isExpired()) continue;
            this.buffer.remove(key);
        }
    }
}

