/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.netio.request.handle;

import java.lang.instrument.ClassDefinition;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import scouter.agent.batch.Configure;
import scouter.agent.batch.JavaAgent;
import scouter.agent.batch.netio.request.anotation.RequestHandler;
import scouter.lang.conf.ValueType;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.BooleanValue;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.util.ClassUtil;
import scouter.util.StringKeyLinkedMap;

public class AgentConfigure {
    protected boolean applyConfigRunning = false;

    @RequestHandler(value="GET_CONFIGURE_WAS")
    public Pack getAgentConfigure(Pack param) {
        MapPack p = new MapPack();
        p.put("configKey", Configure.getInstance().getKeyValueInfo().getList("key"));
        String config = Configure.getInstance().loadText();
        if (config == null) {
            config = "";
        }
        p.put("agentConfig", config);
        return p;
    }

    @RequestHandler(value="SET_CONFIGURE_WAS")
    public Pack setAgentConfigure(Pack param) {
        String setConfig = ((MapPack)param).getText("setConfig");
        boolean success = Configure.getInstance().saveText(setConfig);
        if (success) {
            Configure.getInstance().reload();
        }
        MapPack p = new MapPack();
        p.put("result", String.valueOf(success));
        return p;
    }

    @RequestHandler(value="LIST_CONFIGURE_WAS")
    public Pack listConfigure(Pack param) {
        MapValue m = Configure.getInstance().getKeyValueInfo();
        MapPack pack = new MapPack();
        pack.put("key", m.getList("key"));
        pack.put("value", m.getList("value"));
        pack.put("default", m.getList("default"));
        return pack;
    }

    @RequestHandler(value="REDEFINE_CLASSES")
    public Pack redefineClasses(Pack param) {
        MapPack p = new MapPack();
        ListValue classLv = ((MapPack)param).getList("class");
        HashSet<String> paramSet = new HashSet<String>();
        for (int i = 0; i < classLv.size(); ++i) {
            String className = classLv.getString(i);
            paramSet.add(className);
        }
        Class[] classes = JavaAgent.getInstrumentation().getAllLoadedClasses();
        ArrayList<ClassDefinition> definitionList = new ArrayList<ClassDefinition>();
        boolean allSuccess = true;
        for (int i = 0; paramSet.size() > 0 && i < classes.length; ++i) {
            if (!paramSet.contains(classes[i].getName())) continue;
            try {
                byte[] buff = ClassUtil.getByteCode(classes[i]);
                if (buff == null) continue;
                definitionList.add(new ClassDefinition(classes[i], buff));
                paramSet.remove(classes[i].getName());
                continue;
            }
            catch (Exception e) {
                p.put("success", new BooleanValue(false));
                p.put("error", e.toString());
                allSuccess = false;
                break;
            }
        }
        if (definitionList.size() > 0 && allSuccess) {
            try {
                JavaAgent.getInstrumentation().redefineClasses(definitionList.toArray(new ClassDefinition[definitionList.size()]));
                p.put("success", new BooleanValue(true));
            }
            catch (Throwable th) {
                p.put("success", new BooleanValue(false));
                p.put("error", th.toString());
            }
        }
        return p;
    }

    @RequestHandler(value="CONFIGURE_DESC")
    public Pack getConfigureDesc(Pack param) {
        StringKeyLinkedMap<String> descMap = Configure.getInstance().getConfigureDesc();
        MapPack pack = new MapPack();
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<String>> entries = descMap.entries();
        while (entries.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<String> entry = entries.nextElement();
            pack.put(entry.getKey(), entry.getValue());
        }
        return pack;
    }

    @RequestHandler(value="CONFIGURE_VALUE_TYPE")
    public Pack getConfigureValueType(Pack param) {
        StringKeyLinkedMap<ValueType> valueTypeMap = Configure.getInstance().getConfigureValueType();
        MapPack pack = new MapPack();
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<ValueType>> entries = valueTypeMap.entries();
        while (entries.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<ValueType> entry = entries.nextElement();
            pack.put(entry.getKey(), entry.getValue().getType());
        }
        return pack;
    }
}

