/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.netio.service.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import scouter.agent.batch.Configure;
import scouter.agent.batch.netio.request.ReqestHandlingProxy;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.Pack;
import scouter.util.FileUtil;
import scouter.util.IntKeyLinkedMap;

public class TcpWorker
implements Runnable {
    public static IntKeyLinkedMap<TcpWorker> LIVE = new IntKeyLinkedMap();
    public static String localAddr = null;
    public int objHash = Configure.getInstance().getObjHash();
    protected Socket socket = null;

    @Override
    public void run() {
        if (this.socket == null) {
            return;
        }
        try {
            this.processV2(this.socket);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.close();
        }
    }

    public void close() {
        FileUtil.close(this.socket);
        this.socket = null;
        LIVE.remove(this.hashCode());
    }

    public boolean prepare() {
        Configure conf = Configure.getInstance();
        String host = conf.net_collector_ip;
        int port = conf.net_collector_tcp_port;
        int so_timeout = conf.net_collector_tcp_so_timeout_ms;
        int connection_timeout = conf.net_collector_tcp_connection_timeout_ms;
        this.socket = new Socket();
        try {
            this.socket.connect(new InetSocketAddress(host, port), connection_timeout);
            this.socket.setSoTimeout(so_timeout);
            if (localAddr == null) {
                localAddr = this.socket.getLocalAddress().getHostAddress();
            }
            LIVE.put(this.hashCode(), this);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Socket socket) throws IOException {
        DataInputX in = null;
        DataOutputX out = null;
        try {
            in = new DataInputX(new BufferedInputStream(socket.getInputStream()));
            out = new DataOutputX(new BufferedOutputStream(socket.getOutputStream()));
            out.writeInt(-889319423);
            out.writeInt(this.objHash);
            out.flush();
            while (this.objHash == Configure.getInstance().getObjHash()) {
                Pack parameter;
                String cmd = in.readText();
                Pack res = ReqestHandlingProxy.process(cmd, parameter = in.readPack(), in, out);
                if (res != null) {
                    out.writeByte(3);
                    out.writePack(res);
                }
                out.writeByte(4);
                out.flush();
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(in);
            FileUtil.close(out);
            throw throwable;
        }
        FileUtil.close(in);
        FileUtil.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processV2(Socket socket) throws IOException {
        DataInputX in = null;
        DataOutputX out = null;
        Configure conf = Configure.getInstance();
        try {
            in = new DataInputX(new BufferedInputStream(socket.getInputStream()));
            out = new DataOutputX(new BufferedOutputStream(socket.getOutputStream()));
            String server_addr = conf.net_collector_ip;
            int port = conf.net_collector_tcp_port;
            out.writeInt(-889319422);
            out.writeInt(this.objHash);
            out.flush();
            while (this.objHash == Configure.getInstance().getObjHash() && server_addr.equals(conf.net_collector_ip) && port == conf.net_collector_tcp_port) {
                Pack parameter;
                byte[] buff = in.readIntBytes();
                DataInputX in2 = new DataInputX(buff);
                String cmd = in2.readText();
                Pack res = ReqestHandlingProxy.process(cmd, parameter = in2.readPack(), in, out);
                if (res != null) {
                    out.writeByte(3);
                    byte[] obuff = new DataOutputX().writePack(res).toByteArray();
                    out.writeIntBytes(obuff);
                }
                out.writeByte(4);
                out.flush();
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(in);
            FileUtil.close(out);
            throw throwable;
        }
        FileUtil.close(in);
        FileUtil.close(out);
    }
}

