/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.task;

import java.io.File;
import scouter.agent.batch.Configure;
import scouter.agent.batch.Logger;
import scouter.util.ThreadUtil;

public class LogMonitor
extends Thread {
    private static LogMonitor instance = null;

    public static LogMonitor getInstance() {
        if (instance == null) {
            instance = new LogMonitor();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName(instance));
            instance.start();
        }
        return instance;
    }

    @Override
    public void run() {
        long logKeepTime = 0L;
        long currentTime = 0L;
        try {
            Configure config = Configure.getInstance();
            while (!config.scouter_stop) {
                currentTime = System.currentTimeMillis();
                logKeepTime = (long)config.log_keep_days * 86400000L;
                this.deleteLogFiles(config.sfa_dump_dir, currentTime, logKeepTime, new String[]{".log", ".inx", ".sbr"}, true, 0);
                this.deleteLogFiles(new File(config.log_dir), currentTime, logKeepTime, new String[]{".log"}, false, 0);
                Thread.sleep(3600000L);
            }
        }
        catch (Throwable ex) {
            Logger.println("ERROR: " + ex.getMessage());
        }
    }

    private boolean deleteLogFiles(File dir, long currentTime, long logKeeptime, String[] fileExtension, boolean isDeleteEmpty, int index) {
        int listSize = 0;
        int deleteSize = 0;
        try {
            File[] list = dir.listFiles();
            if (list == null) {
                return false;
            }
            listSize = list.length;
            for (File file : list) {
                long lastTime;
                String fileName = file.getName();
                if (fileName.equals(".") || fileName.equals("..")) {
                    ++deleteSize;
                    continue;
                }
                if (file.isDirectory()) {
                    if (!this.deleteLogFiles(file, currentTime, logKeeptime, fileExtension, isDeleteEmpty, index + 1)) continue;
                    file.delete();
                    ++deleteSize;
                    Logger.println("LOG: delete directory - " + file.getAbsolutePath());
                    continue;
                }
                if (!this.checkExtenstion(fileName, fileExtension) || currentTime - (lastTime = file.lastModified()) < logKeeptime) continue;
                file.delete();
                ++deleteSize;
                Logger.println("LOG: delete file - " + file.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            Logger.println("ERROR: LogDelete - " + ex.getMessage());
        }
        return listSize == deleteSize;
    }

    private boolean checkExtenstion(String fileName, String[] fileExtenstion) {
        if (fileExtenstion == null) {
            return false;
        }
        for (String extension : fileExtenstion) {
            if (!fileName.endsWith(extension)) continue;
            return true;
        }
        return false;
    }
}

