/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.task;

import java.io.File;
import java.io.FileWriter;
import scouter.agent.batch.Configure;
import scouter.agent.batch.Logger;
import scouter.agent.batch.netio.data.net.UdpLocalAgent;
import scouter.agent.batch.trace.TraceContext;

public class ResultSender
extends Thread {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Configure config = null;
        TraceContext traceContext = null;
        long elapsedTime = 0L;
        try {
            config = Configure.getInstance();
            config.scouter_stop = true;
            traceContext = TraceContext.getInstance();
            traceContext.endTime = System.currentTimeMillis();
            elapsedTime = traceContext.endTime - traceContext.startTime;
            if (config.batch_log_send_elapsed_ms <= elapsedTime) {
                traceContext.caculateLast();
                String result = traceContext.toString();
                if (config.scouter_standalone || config.sbr_log_make) {
                    this.saveStandAloneResult(traceContext, result);
                }
                Logger.println(result);
            }
        }
        catch (Throwable ex) {
            Logger.println("Scouter ResultSender(run) Exception: " + ex.getMessage());
        }
        finally {
            try {
                if (config != null && traceContext != null) {
                    if (!config.scouter_standalone) {
                        if (config.batch_log_send_elapsed_ms <= elapsedTime) {
                            if (config.sfa_dump_enabled && config.sfa_dump_send_elapsed_ms > elapsedTime) {
                                traceContext.isStackLogFile = false;
                            }
                            UdpLocalAgent.sendUdpPackToServer(traceContext.makePack());
                        }
                        if (config.sfa_dump_enabled && config.sfa_dump_send_elapsed_ms <= elapsedTime) {
                            UdpLocalAgent.sendDumpFileInfo(traceContext);
                        }
                    }
                    if (config.sfa_dump_enabled && config.sfa_dump_send_elapsed_ms > elapsedTime) {
                        this.deleteFiles(traceContext);
                    }
                    UdpLocalAgent.sendEndInfo(traceContext);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveStandAloneResult(TraceContext traceContext, String result) {
        File resultFile = new File(traceContext.getLogFullFilename() + ".sbr");
        if (resultFile.exists()) {
            return;
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(resultFile);
            writer.write(result);
        }
        catch (Throwable ex) {
            Logger.println("Scouter ResultSender(save) Exception: " + ex.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void deleteFiles(TraceContext traceContext) {
        String filename = traceContext.getLogFullFilename();
        try {
            File file = new File(filename + ".log");
            file.delete();
            file = new File(filename + ".inx");
            file.delete();
        }
        catch (Throwable ex) {
            Logger.println("Scouter ResultSender(delete) Exception: " + ex.getMessage());
        }
    }
}

