/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.task;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import scouter.agent.batch.Configure;
import scouter.agent.batch.Logger;
import scouter.agent.batch.Main;
import scouter.agent.batch.counter.CounterBasket;
import scouter.agent.batch.netio.data.net.UdpAgent;
import scouter.agent.batch.netio.data.net.UdpLocalServer;
import scouter.io.DataOutputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.PerfCounterPack;
import scouter.lang.value.DecimalValue;
import scouter.net.NetCafe;

public class StatusSender {
    private Configure conf = Configure.getInstance();
    private InetAddress server;
    private CounterBasket cb = new CounterBasket();
    private long lastCheckTime = 0L;

    public StatusSender() {
        try {
            this.server = InetAddress.getByName(this.conf.net_collector_ip);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.server = null;
        }
    }

    public void sendBatchService(long currentTime) {
        if (this.server == null) {
            return;
        }
        this.checkBatchService(currentTime);
        this.updateBatchService();
        PerfCounterPack[] pks = this.cb.getList();
        this.sendCounter(pks);
    }

    private void updateBatchService() {
        PerfCounterPack pack = this.cb.getPack(this.conf.getObjName(), (byte)1);
        UdpLocalServer localServer = UdpLocalServer.getInstance();
        pack.put("BatchService", new DecimalValue(Main.batchMap.size()));
        pack.put("BatchStart", new DecimalValue(localServer.getStartBatchs()));
        pack.put("BatchEnd", new DecimalValue(localServer.getEndBatchs()));
        pack.put("BatchEndNoSignal", new DecimalValue(localServer.getEndNoSignalBatchs()));
    }

    private void checkBatchService(long currentTime) {
        boolean isCheck = false;
        if (currentTime - this.lastCheckTime >= (long)this.conf.sfa_dump_interval_ms) {
            isCheck = true;
            this.lastCheckTime = currentTime;
        }
        if (!isCheck) {
            return;
        }
        try {
            long stdTime = this.conf.sfa_dump_interval_ms * 5;
            for (String key : Main.batchMap.keySet()) {
                MapPack map = Main.batchMap.get(key);
                long gapTime = currentTime - (map.getLong("startTime") + map.getLong("elapsedTime"));
                if (gapTime < stdTime) continue;
                Main.batchMap.remove(key);
                UdpLocalServer.getInstance().addEndNoSignalBatchs();
                Logger.println("remove " + key + " in batchMap");
            }
        }
        catch (Throwable th) {
            Logger.println("E002", "Exception to check batchMap", th);
        }
    }

    private void sendCounter(PerfCounterPack[] p) {
        try {
            ArrayList<byte[]> buff = new ArrayList<byte[]>();
            int bytes = 0;
            for (int k = 0; k < p.length; ++k) {
                byte[] b = new DataOutputX().writePack(p[k]).toByteArray();
                if (bytes + b.length >= this.conf.net_udp_packet_max_bytes) {
                    this.sendDirect(buff);
                    bytes = 0;
                    buff.clear();
                }
                bytes += b.length;
                buff.add(b);
            }
            this.sendDirect(buff);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendDirect(List<byte[]> buff) {
        switch (buff.size()) {
            case 0: {
                return;
            }
            case 1: {
                this.write(buff.get(0));
                break;
            }
            default: {
                this.write(buff);
            }
        }
    }

    private boolean write(byte[] p) {
        try {
            if (p.length > this.conf.net_udp_packet_max_bytes) {
                return UdpAgent.sendMTU(this.server, this.conf.net_collector_udp_port, p, this.conf.net_udp_packet_max_bytes);
            }
            DataOutputX out = new DataOutputX();
            out.write(NetCafe.CAFE);
            out.write(p);
            UdpAgent.sendUdp(this.server, this.conf.net_collector_udp_port, out.toByteArray());
            return true;
        }
        catch (IOException e) {
            Logger.println("A120", "UDP", e);
            return false;
        }
    }

    private boolean write(List<byte[]> p) {
        try {
            DataOutputX buffer = new DataOutputX();
            int bufferCount = 0;
            for (int i = 0; i < p.size(); ++i) {
                byte[] b = p.get(i);
                if (b.length > this.conf.net_udp_packet_max_bytes) {
                    UdpAgent.sendMTU(this.server, this.conf.net_collector_udp_port, b, this.conf.net_udp_packet_max_bytes);
                    continue;
                }
                if (b.length + buffer.getWriteSize() > this.conf.net_udp_packet_max_bytes) {
                    this.sendList(bufferCount, buffer.toByteArray());
                    buffer = new DataOutputX();
                    bufferCount = 0;
                    continue;
                }
                ++bufferCount;
                buffer.write(b);
            }
            if (buffer.getWriteSize() > 0) {
                this.sendList(bufferCount, buffer.toByteArray());
            }
            return true;
        }
        catch (IOException e) {
            Logger.println("A123", "UDP", e);
            return false;
        }
    }

    private void sendList(int bufferCount, byte[] buffer) throws IOException {
        DataOutputX out = new DataOutputX();
        out.write(NetCafe.CAFE_N);
        out.writeShort(bufferCount);
        out.write(buffer);
        UdpAgent.sendUdp(this.server, this.conf.net_collector_udp_port, out.toByteArray());
    }
}

