/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.trace;

import scouter.agent.batch.trace.LocalSQL;
import scouter.agent.batch.trace.TraceContext;
import scouter.agent.batch.trace.TraceSQL;

public class TraceContextManager {
    private static ThreadLocal<LocalSQL> local = new ThreadLocal();

    public static LocalSQL getLocalSQL() {
        LocalSQL localSql = local.get();
        if (localSql == null) {
            localSql = new LocalSQL();
            local.set(localSql);
            TraceContext.getInstance().addLocalSQL(localSql);
        }
        return localSql;
    }

    public static void endThread() {
        LocalSQL localSql = local.get();
        local.set(null);
        TraceContext.getInstance().removeLocalSQL(localSql);
    }

    public static TraceSQL getTraceSQL(String sqlText) {
        TraceSQL traceSql = TraceContextManager.getLocalSQL().get(sqlText);
        return traceSql;
    }

    public static TraceSQL getCurrentTraceSQL() {
        return TraceContextManager.getLocalSQL().getCurrentTraceSQL();
    }

    public static TraceSQL startTraceSQL(String sqlText) {
        TraceSQL traceSql = TraceContextManager.getTraceSQL(sqlText);
        traceSql.start();
        return traceSql;
    }
}

