/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.trace;

public class TraceSQL {
    public static final String CURRENT_TRACESQL_FIELD = "_current_trace_sql_";
    public Integer hashValue;
    public int runs = 0;
    public long startTime = -1L;
    public long endTime = 0L;
    public long totalTime = 0L;
    public long minTime = Long.MAX_VALUE;
    public long maxTime = 0L;
    public long processedRows = 0L;
    public boolean rowed = false;
    public long sqlStartTime;

    public void start() {
        if (this.startTime == -1L) {
            this.startTime = System.currentTimeMillis();
        }
        this.sqlStartTime = System.nanoTime();
    }

    public void end() {
        long responseTime = System.nanoTime() - this.sqlStartTime;
        ++this.runs;
        this.totalTime += responseTime;
        if (this.minTime > responseTime) {
            this.minTime = responseTime;
        }
        if (this.maxTime < responseTime) {
            this.maxTime = responseTime;
        }
        this.endTime = System.currentTimeMillis();
    }

    public void addRow() {
        if (!this.rowed) {
            this.rowed = true;
        }
        ++this.processedRows;
    }

    public void addRow(int rows) {
        if (!this.rowed) {
            this.rowed = true;
        }
        if (rows > 0) {
            this.processedRows += (long)rows;
        }
    }

    public void addRows(int[] rows) {
        if (rows == null || rows.length < 1) {
            return;
        }
        if (!this.rowed) {
            this.rowed = true;
        }
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i] > 0) {
                this.processedRows += (long)rows[i];
                continue;
            }
            if (rows[i] != -2) continue;
            ++this.processedRows;
        }
    }

    public long getTotalTimeByMillis() {
        return this.totalTime / 1000000L;
    }

    public long getTotalTimeByMicro() {
        return this.totalTime / 1000L;
    }

    public long getMinTimeByMillis() {
        return this.minTime / 1000000L;
    }

    public long getMinTimeByMicro() {
        return this.minTime / 1000L;
    }

    public long getMaxTimeByMillis() {
        return this.maxTime / 1000000L;
    }

    public long getMaxTimeByMicro() {
        return this.maxTime / 1000L;
    }
}

