/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang;

import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.TimeTypeEnum;
import scouter.lang.pack.MapPack;

public class CounterKey
implements Comparable {
    public int objHash;
    public String counter;
    public byte timetype;

    private CounterKey() {
    }

    public CounterKey(int objHash, String counter, byte timetype) {
        this.objHash = objHash;
        this.counter = counter == null ? "" : counter;
        this.timetype = timetype;
    }

    public int compareTo(Object obj) {
        if (obj instanceof CounterKey) {
            CounterKey o = (CounterKey)obj;
            if (this.objHash != o.objHash) {
                return this.objHash - o.objHash;
            }
            int x = this.counter.compareTo(o.counter);
            return x != 0 ? x : this.timetype - o.timetype;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CounterKey) {
            CounterKey o = (CounterKey)obj;
            return this.objHash == o.objHash && this.counter.equals(o.counter) && this.timetype == o.timetype;
        }
        return false;
    }

    public int hashCode() {
        return this.objHash ^ this.counter.hashCode() ^ this.timetype;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" objHash=").append(this.objHash);
        sb.append(" counter=").append(this.counter);
        sb.append(" timetype=").append(TimeTypeEnum.get(this.timetype));
        return sb.toString();
    }

    public byte[] getBytesKey() {
        try {
            DataOutputX out = new DataOutputX();
            out.writeInt(this.objHash);
            out.writeText(this.counter);
            out.writeByte(this.timetype);
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CounterKey toCounterKey(byte[] param) {
        try {
            DataInputX in = new DataInputX(param);
            CounterKey ck = new CounterKey();
            ck.objHash = in.readInt();
            ck.counter = in.readText();
            ck.timetype = in.readByte();
            return ck;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static MapPack toMapPacket(CounterKey key) {
        MapPack param = new MapPack();
        param.put("objHash", key.objHash);
        param.put("counter", key.counter);
        param.put("timetype", key.timetype);
        return param;
    }

    public static CounterKey toCounterKey(MapPack param) {
        CounterKey ck = new CounterKey();
        ck.objHash = param.getInt("objHash");
        ck.counter = param.getText("counter");
        ck.timetype = (byte)param.getInt("timetype");
        return ck;
    }
}

