/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import scouter.util.CompareUtil;

public class LinkedMap<K, V> {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private LinkedEntry<K, V>[] table;
    private LinkedEntry<K, V> header;
    private int count;
    private int threshold;
    private float loadFactor;
    private int max;

    public LinkedMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new LinkedEntry[initCapacity];
        this.header = new LinkedEntry<Object, Object>(null, null, null);
        this.header.link_prev = this.header;
        this.header.link_next = this.header.link_prev;
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public LinkedMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public synchronized Enumeration<K> keys() {
        return new Enumer(TYPE.KEYS);
    }

    public synchronized Enumeration<V> values() {
        return new Enumer(TYPE.VALUES);
    }

    public synchronized Enumeration<LinkedEntry<K, V>> entries() {
        return new Enumer(TYPE.ENTRIES);
    }

    public synchronized boolean containsValue(V value) {
        if (value == null) {
            return false;
        }
        LinkedEntry<K, V>[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            LinkedEntry<K, V> e = tab[i];
            while (e != null) {
                if (CompareUtil.equals(e.value, value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        LinkedEntry<K, V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LinkedEntry<K, V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized V get(K key) {
        if (key == null) {
            return null;
        }
        LinkedEntry<K, V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LinkedEntry<K, V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public synchronized V getFirstValue() {
        if (this.isEmpty()) {
            return null;
        }
        return this.header.link_next.value;
    }

    public synchronized V getLastValue() {
        if (this.isEmpty()) {
            return null;
        }
        return this.header.link_prev.value;
    }

    private int hash(Object key) {
        return key.hashCode() & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        LinkedEntry<K, V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        LinkedEntry[] newMap = new LinkedEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            LinkedEntry<K, V> old = oldMap[i];
            while (old != null) {
                LinkedEntry<K, V> e = old;
                old = old.next;
                Object key = e.key;
                int index = this.hash(key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public LinkedMap<K, V> setMax(int max) {
        this.max = max;
        return this;
    }

    public V put(K key, V value) {
        return this._put(key, value, MODE.LAST);
    }

    public V putLast(K key, V value) {
        return this._put(key, value, MODE.FORCE_LAST);
    }

    public V putFirst(K key, V value) {
        return this._put(key, value, MODE.FORCE_FIRST);
    }

    private synchronized V _put(K key, V value, MODE m) {
        LinkedEntry<K, V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LinkedEntry<K, V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                Object old = e.value;
                e.value = value;
                switch (m) {
                    case FORCE_FIRST: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case FORCE_LAST: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case FORCE_FIRST: 
                case FIRST: {
                    Object k;
                    while (this.count >= this.max) {
                        k = this.header.link_prev.key;
                        V v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case FORCE_LAST: 
                case LAST: {
                    Object k;
                    while (this.count >= this.max) {
                        k = this.header.link_next.key;
                        V v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new LinkedEntry<K, V>(key, value, tab[index]);
        switch (m) {
            case FORCE_FIRST: 
            case FIRST: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case FORCE_LAST: 
            case LAST: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return null;
    }

    protected void overflowed(K key, V value) {
    }

    protected V create(K key) {
        throw new RuntimeException("not implemented create()");
    }

    public V intern(K key) {
        return this._intern(key, MODE.LAST);
    }

    private synchronized V _intern(K key, MODE m) {
        LinkedEntry<K, V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LinkedEntry<K, V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                Object old = e.value;
                switch (m) {
                    case FORCE_FIRST: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case FORCE_LAST: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.next;
        }
        V value = this.create(key);
        if (value == null) {
            return null;
        }
        if (this.max > 0) {
            switch (m) {
                case FORCE_FIRST: 
                case FIRST: {
                    Object k;
                    while (this.count >= this.max) {
                        k = this.header.link_prev.key;
                        V v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case FORCE_LAST: 
                case LAST: {
                    Object k;
                    while (this.count >= this.max) {
                        k = this.header.link_next.key;
                        V v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        LinkedEntry<K, V> e2 = new LinkedEntry<K, V>(key, value, tab[index]);
        tab[index] = e2;
        switch (m) {
            case FORCE_FIRST: 
            case FIRST: {
                this.chain(this.header, this.header.link_next, e2);
                break;
            }
            case FORCE_LAST: 
            case LAST: {
                this.chain(this.header.link_prev, this.header, e2);
            }
        }
        ++this.count;
        return value;
    }

    public synchronized V remove(K key) {
        if (key == null) {
            return null;
        }
        LinkedEntry<K, V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LinkedEntry<K, V> e = tab[index];
        LinkedEntry<K, V> prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                this.unchain(e);
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized V removeFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized V removeLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void clear() {
        LinkedEntry<K, V>[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_prev = this.header;
        this.header.link_next = this.header.link_prev;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<LinkedEntry<K, V>> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            LinkedEntry<K, V> e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toKeyString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<K> it = this.keys();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            K key = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(key);
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<LinkedEntry<K, V>> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            LinkedEntry<K, V> e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(LinkedEntry link_prev, LinkedEntry link_next, LinkedEntry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(LinkedEntry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public synchronized void sort(Comparator<LinkedEntry<K, V>> c) {
        ArrayList<LinkedEntry<K, V>> list = new ArrayList<LinkedEntry<K, V>>(this.size());
        Enumeration<LinkedEntry<K, V>> en = this.entries();
        while (en.hasMoreElements()) {
            LinkedEntry<K, V> n = en.nextElement();
            if (n == null) continue;
            list.add(n);
        }
        Collections.sort(list, c);
        this.clear();
        for (int i = 0; i < list.size(); ++i) {
            LinkedEntry e = (LinkedEntry)list.get(i);
            this.put(e.getKey(), e.getValue());
        }
    }

    public static class LinkedEntry<K, V> {
        K key;
        V value;
        LinkedEntry<K, V> next;
        LinkedEntry<K, V> link_next;
        LinkedEntry<K, V> link_prev;

        protected LinkedEntry(K key, V value, LinkedEntry<K, V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new LinkedEntry<K, V>(this.key, this.value, this.next == null ? null : (LinkedEntry)this.next.clone());
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LinkedEntry)) {
                return false;
            }
            LinkedEntry e = (LinkedEntry)o;
            return CompareUtil.equals(this.key, e.key) && CompareUtil.equals(this.value, e.value);
        }

        public int hashCode() {
            return this.key.hashCode() ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class Enumer<V>
    implements Enumeration {
        TYPE type;
        LinkedEntry entry;
        LinkedEntry lastEnt;

        Enumer(TYPE type) {
            this.entry = ((LinkedMap)LinkedMap.this).header.link_next;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            return LinkedMap.this.header != this.entry && this.entry != null;
        }

        public V nextElement() {
            if (this.hasMoreElements()) {
                LinkedEntry e = this.lastEnt = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case KEYS: {
                        return (V)e.key;
                    }
                    case VALUES: {
                        return e.value;
                    }
                }
                return (V)e;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    private static enum TYPE {
        KEYS,
        VALUES,
        ENTRIES;

    }

    private static enum MODE {
        FORCE_FIRST,
        FORCE_LAST,
        FIRST,
        LAST;

    }
}

