/*
 * Decompiled with CFR 0.152.
 */
package scouter.server;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.control.Breaks$;
import scouter.server.ConfObserver$;
import scouter.server.Configure;
import scouter.server.Logger$;
import scouter.server.util.ThreadScala$;
import scouter.util.CompareUtil;
import scouter.util.DateUtil;
import scouter.util.FileUtil;
import scouter.util.StringLongLinkedMap;
import scouter.util.ThreadUtil;

public final class Logger$ {
    public static final Logger$ MODULE$;
    private final String serverLogPrefix;
    private final String scouter$server$Logger$$serverLogPrefixWithHyphen;
    private final String scouter$server$Logger$$requestLogPrefixWithHyphen;
    private final StringLongLinkedMap lastLog;
    private PrintWriter pw;
    private long scouter$server$Logger$$lastDataUnit;
    private String scouter$server$Logger$$lastDir;
    private boolean scouter$server$Logger$$lastFileRotation;
    private final Configure conf;

    static {
        new Logger$();
    }

    private String serverLogPrefix() {
        return this.serverLogPrefix;
    }

    public String scouter$server$Logger$$serverLogPrefixWithHyphen() {
        return this.scouter$server$Logger$$serverLogPrefixWithHyphen;
    }

    public String scouter$server$Logger$$requestLogPrefixWithHyphen() {
        return this.scouter$server$Logger$$requestLogPrefixWithHyphen;
    }

    private StringLongLinkedMap lastLog() {
        return this.lastLog;
    }

    public void trace(Object message) {
        if (this.conf()._trace) {
            this.printlnInternal(new StringBuilder().append((Object)DateUtil.datetime(System.currentTimeMillis())).append((Object)" [TRACE] ").append(message).toString());
        }
    }

    public void println(Object message) {
        this.printlnInternal(new StringBuilder().append((Object)DateUtil.datetime(System.currentTimeMillis())).append((Object)" ").append(message).toString());
    }

    public void println(String id, Object message) {
        if (!this.checkOk(id, 0)) {
            return;
        }
        this.printlnInternal(new StringBuilder().append((Object)DateUtil.datetime(System.currentTimeMillis())).append((Object)" [").append((Object)id).append((Object)"] ").append(message).toString());
    }

    public void println(String id, int sec, Object message) {
        if (!this.checkOk(id, sec)) {
            return;
        }
        this.printlnInternal(new StringBuilder().append((Object)DateUtil.datetime(System.currentTimeMillis())).append((Object)" [").append((Object)id).append((Object)"] ").append(message).toString());
    }

    public void println(String id, int sec, Object message, Throwable t) {
        if (!this.checkOk(id, sec)) {
            return;
        }
        this.printlnInternal(new StringBuilder().append((Object)DateUtil.datetime(System.currentTimeMillis())).append((Object)" [").append((Object)id).append((Object)"] ").append(message).toString());
        this.printlnInternal(ThreadUtil.getStackTrace(t));
    }

    public void printStackTrace(Throwable t) {
        this.println(this.getCallStack(t));
    }

    public void printStackTrace(String id, Throwable t) {
        this.println(id, this.getCallStack(t));
    }

    public String getCallStack(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            t.printStackTrace(pw);
            return sw.toString();
        }
        finally {
            pw.close();
        }
    }

    private boolean checkOk(String id, int sec) {
        Object object;
        if (Configure.getInstance().mgr_log_ignore_ids.hasKey(id)) {
            return false;
        }
        if (sec > 0) {
            long last = this.lastLog().get(id);
            long now = System.currentTimeMillis();
            if (now < last + (long)(sec * 1000)) {
                return false;
            }
            object = BoxesRunTime.boxToLong((long)this.lastLog().put(id, now));
        } else {
            object = BoxedUnit.UNIT;
        }
        return true;
    }

    public PrintWriter pw() {
        return this.pw;
    }

    public void pw_$eq(PrintWriter x$1) {
        this.pw = x$1;
    }

    public long scouter$server$Logger$$lastDataUnit() {
        return this.scouter$server$Logger$$lastDataUnit;
    }

    public void scouter$server$Logger$$lastDataUnit_$eq(long x$1) {
        this.scouter$server$Logger$$lastDataUnit = x$1;
    }

    public String scouter$server$Logger$$lastDir() {
        return this.scouter$server$Logger$$lastDir;
    }

    public void scouter$server$Logger$$lastDir_$eq(String x$1) {
        this.scouter$server$Logger$$lastDir = x$1;
    }

    public boolean scouter$server$Logger$$lastFileRotation() {
        return this.scouter$server$Logger$$lastFileRotation;
    }

    public void scouter$server$Logger$$lastFileRotation_$eq(boolean x$1) {
        this.scouter$server$Logger$$lastFileRotation = x$1;
    }

    private void printlnInternal(String msg) {
        block7: {
            try {
                if (this.pw() == null) {
                    this.openFile();
                    if (this.pw() == null) {
                        System.out.println(msg);
                    } else {
                        if (this.conf()._trace) {
                            System.out.println(msg);
                        }
                        this.pw().println(msg);
                        this.pw().flush();
                    }
                    break block7;
                }
                if (this.conf()._trace) {
                    System.out.println(msg);
                }
                this.pw().println(msg);
                this.pw().flush();
                return;
            }
            catch (Exception exception) {
                FileUtil.close(this.pw());
                this.pw_$eq(null);
                System.out.println(msg);
            }
        }
    }

    public Configure conf() {
        return this.conf;
    }

    private synchronized void openFile() {
        if (this.pw() == null) {
            this.scouter$server$Logger$$lastDataUnit_$eq(DateUtil.getDateUnit());
            this.scouter$server$Logger$$lastDir_$eq(this.conf().log_dir);
            this.scouter$server$Logger$$lastFileRotation_$eq(this.conf().log_rotation_enabled);
            new File(this.scouter$server$Logger$$lastDir()).mkdirs();
            if (this.conf().log_rotation_enabled) {
                FileWriter fw = new FileWriter(new File(this.conf().log_dir, new StringBuilder().append((Object)this.scouter$server$Logger$$serverLogPrefixWithHyphen()).append((Object)DateUtil.yyyymmdd()).append((Object)".log").toString()), true);
                this.pw_$eq(new PrintWriter(fw));
            } else {
                this.pw_$eq(new PrintWriter(new File(this.conf().log_dir, new StringBuilder().append((Object)this.serverLogPrefix()).append((Object)".log").toString())));
            }
            this.scouter$server$Logger$$lastDataUnit_$eq(DateUtil.getDateUnit());
        }
    }

    public void clearOldLog() {
        if (!this.conf().log_rotation_enabled) {
            return;
        }
        if (this.conf().log_keep_days <= 0) {
            return;
        }
        long nowUnit = DateUtil.getDateUnit();
        File dir = new File(this.conf().log_dir);
        File[] files = dir.listFiles();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), files.length - 1).foreach$mVc$sp((Function1)new Serializable(nowUnit, files){
            public static final long serialVersionUID = 0L;
            public final long nowUnit$1;
            public final File[] files$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Breaks$.MODULE$.breakable((Function0)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.clearOldLog.1 $outer;
                    private final int i$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void apply$mcV$sp() {
                        if (this.$outer.files$1[this.i$1].isDirectory()) {
                            throw Breaks$.MODULE$.break();
                        }
                        String name = this.$outer.files$1[this.i$1].getName();
                        String prefix = null;
                        if (name.startsWith(Logger$.MODULE$.scouter$server$Logger$$serverLogPrefixWithHyphen())) {
                            prefix = Logger$.MODULE$.scouter$server$Logger$$serverLogPrefixWithHyphen();
                        } else {
                            if (!name.startsWith(Logger$.MODULE$.scouter$server$Logger$$requestLogPrefixWithHyphen())) throw Breaks$.MODULE$.break();
                            prefix = Logger$.MODULE$.scouter$server$Logger$$requestLogPrefixWithHyphen();
                        }
                        int x = name.lastIndexOf(46);
                        if (x < 0) {
                            throw Breaks$.MODULE$.break();
                        }
                        String date = name.substring(prefix.length(), x);
                        if (date.length() != 8) {
                            throw Breaks$.MODULE$.break();
                        }
                        try {
                            long d = DateUtil.yyyymmdd(date);
                            long fileUnit = DateUtil.getDateUnit(d);
                            if (this.$outer.nowUnit$1 - fileUnit <= (long)Logger$.MODULE$.conf().log_keep_days) return;
                            this.$outer.files$1[this.i$1].delete();
                            Logger$.MODULE$.println(new StringBuilder().append((Object)"[scouter] delete log file : ").append((Object)this.$outer.files$1[this.i$1].getAbsolutePath()).toString());
                            return;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                });
            }
            {
                this.nowUnit$1 = nowUnit$1;
                this.files$1 = files$1;
            }
        });
    }

    private Logger$() {
        MODULE$ = this;
        this.serverLogPrefix = "server";
        this.scouter$server$Logger$$serverLogPrefixWithHyphen = new StringBuilder().append((Object)this.serverLogPrefix()).append((Object)"-").toString();
        this.scouter$server$Logger$$requestLogPrefixWithHyphen = "request-";
        this.lastLog = new StringLongLinkedMap().setMax(1000);
        this.pw = null;
        this.scouter$server$Logger$$lastDataUnit = 0L;
        this.scouter$server$Logger$$lastDir = ".";
        this.scouter$server$Logger$$lastFileRotation = true;
        ThreadScala$.MODULE$.startDaemon("scouter.server.Logger", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                long last = System.currentTimeMillis();
                while (true) {
                    long now;
                    if ((now = System.currentTimeMillis()) > last + 3600000L) {
                        last = now;
                        Logger$.MODULE$.clearOldLog();
                    }
                    if (Logger$.MODULE$.scouter$server$Logger$$lastDataUnit() != DateUtil.getDateUnit()) {
                        FileUtil.close(Logger$.MODULE$.pw());
                        Logger$.MODULE$.pw_$eq(null);
                        Logger$.MODULE$.scouter$server$Logger$$lastDataUnit_$eq(DateUtil.getDateUnit());
                    }
                    ThreadUtil.sleep(5000L);
                }
            }
        });
        this.conf = Configure.getInstance();
        ConfObserver$.MODULE$.put("Logger", new Runnable(){

            public void run() {
                if (!CompareUtil.equals(Logger$.MODULE$.scouter$server$Logger$$lastDir(), Logger$.MODULE$.conf().log_dir) || Logger$.MODULE$.scouter$server$Logger$$lastFileRotation() != Logger$.MODULE$.conf().log_rotation_enabled) {
                    FileUtil.close(Logger$.MODULE$.pw());
                    Logger$.MODULE$.pw_$eq(null);
                    Logger$.MODULE$.scouter$server$Logger$$lastDir_$eq(Logger$.MODULE$.conf().log_dir);
                    Logger$.MODULE$.scouter$server$Logger$$lastFileRotation_$eq(Logger$.MODULE$.conf().log_rotation_enabled);
                }
            }
        });
    }
}

