/*
 * Decompiled with CFR 0.152.
 */
package scouter.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import scouter.server.http.model.CounterProtocol;
import scouter.util.StringUtil;

public class ScouterTgMtConfig {
    public static final String X = "X$";
    private String measurement;
    private boolean enabled = true;
    private boolean debugEnabled = false;
    private Map<String, CounterProtocol> counterMapping = new HashMap<String, CounterProtocol>();
    private String objFamilyBase = "X$";
    private List<String> objFamilyAppendTags = new ArrayList<String>();
    private String objTypeBase = "X$";
    private List<String> objTypePrependTags = new ArrayList<String>();
    private List<String> objTypeAppendTags = new ArrayList<String>();
    private String objTypeIcon = "";
    private String objNameBase = "X$";
    private List<String> objNameAppendTags = new ArrayList<String>();
    private String hostTag = "host";
    private Map<String, String> hostMapping = new HashMap<String, String>();
    private Map<String, List<String>> tagFilter = new HashMap<String, List<String>>();

    public ScouterTgMtConfig(String measurement) {
        this.measurement = measurement;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public Map<String, CounterProtocol> getCounterMapping() {
        return this.counterMapping;
    }

    public void setCounterMapping(Map<String, CounterProtocol> counterMapping) {
        this.counterMapping = counterMapping;
    }

    public String getObjFamilyBase() {
        return this.objFamilyBase;
    }

    public void setObjFamilyBase(String objFamilyBase) {
        this.objFamilyBase = X + objFamilyBase;
    }

    public List<String> getObjFamilyAppendTags() {
        return this.objFamilyAppendTags;
    }

    public void setObjFamilyAppendTags(List<String> objFamilyAppendTags) {
        this.objFamilyAppendTags = objFamilyAppendTags;
    }

    public String getObjTypeBase() {
        return this.objTypeBase;
    }

    public void setObjTypeBase(String objTypeBase) {
        this.objTypeBase = objTypeBase;
    }

    public List<String> getObjTypePrependTags() {
        return this.objTypePrependTags;
    }

    public void setObjTypePrependTags(List<String> objTypePrependTags) {
        this.objTypePrependTags = objTypePrependTags;
    }

    public List<String> getObjTypeAppendTags() {
        return this.objTypeAppendTags;
    }

    public void setObjTypeAppendTags(List<String> objTypeAppendTags) {
        this.objTypeAppendTags = objTypeAppendTags;
    }

    public String getObjTypeIcon() {
        return this.objTypeIcon;
    }

    public void setObjTypeIcon(String objTypeIcon) {
        this.objTypeIcon = objTypeIcon;
    }

    public String getObjNameBase() {
        return this.objNameBase;
    }

    public void setObjNameBase(String objNameBase) {
        this.objNameBase = X + objNameBase;
    }

    public List<String> getObjNameAppendTags() {
        return this.objNameAppendTags;
    }

    public void setObjNameAppendTags(List<String> objNameAppendTags) {
        this.objNameAppendTags = objNameAppendTags;
    }

    public String getHostTag() {
        return this.hostTag;
    }

    public void setHostTag(String hostTag) {
        this.hostTag = hostTag;
    }

    public Map<String, String> getHostMapping() {
        return this.hostMapping;
    }

    public void setHostMapping(Map<String, String> hostMapping) {
        this.hostMapping = hostMapping;
    }

    public static String getPrefix() {
        return X;
    }

    public Map<String, List<String>> getTagFilter() {
        return this.tagFilter;
    }

    public void setTagFilter(Map<String, List<String>> tagFilter) {
        this.tagFilter = tagFilter;
    }

    public String toFamily(Map<String, String> tags) {
        StringBuilder objFamilySb = new StringBuilder(this.objFamilyBase);
        for (String tagKey : this.objFamilyAppendTags) {
            objFamilySb.append('_').append(tags.get(tagKey));
        }
        return objFamilySb.toString();
    }

    public String toObjType(Map<String, String> tags) {
        StringBuilder objTypeSb = new StringBuilder();
        for (String tagKey : this.objTypePrependTags) {
            String prependValue = tags.get(tagKey);
            if (!StringUtil.isNotEmpty(prependValue)) continue;
            objTypeSb.append(prependValue).append('_');
        }
        objTypeSb.append(this.objTypeBase);
        for (String tagKey : this.objTypeAppendTags) {
            objTypeSb.append('_').append(tags.get(tagKey));
        }
        return objTypeSb.toString();
    }

    public String toHost(Map<String, String> tags) {
        String host2 = tags.get(this.hostTag);
        if (host2 == null) {
            host2 = "unknown";
        } else {
            String mappedHost = this.hostMapping.get(host2);
            if (mappedHost != null) {
                host2 = mappedHost;
            }
        }
        return host2;
    }

    public String toObjName(String host2, Map<String, String> tags) {
        StringBuilder objNameSb = new StringBuilder(40).append('/').append(host2).append('/').append(this.objNameBase);
        for (String tagKey : this.objNameAppendTags) {
            objNameSb.append('_').append(tags.get(tagKey));
        }
        return objNameSb.toString();
    }

    public CounterProtocol getCounterProtocol(String counterName) {
        return this.counterMapping.get(counterName);
    }

    public boolean isTagFilterMatching(Map<String, String> tags) {
        if (this.tagFilter == null || this.tagFilter.size() == 0) {
            return true;
        }
        boolean matching = false;
        for (Map.Entry<String, List<String>> e : this.tagFilter.entrySet()) {
            List<String> matchStrList = e.getValue();
            for (String matchStr : matchStrList) {
                boolean not = false;
                if (matchStr.charAt(0) == '!') {
                    not = true;
                    matchStr = matchStr.substring(1);
                }
                String value = tags.get(e.getKey());
                if (not) {
                    if (matchStr.equals(value)) continue;
                    matching = true;
                    break;
                }
                if (!matchStr.equals(value)) continue;
                matching = true;
                break;
            }
            if (!matching) continue;
            break;
        }
        return matching;
    }

    public boolean isValidConfig() {
        return !StringUtil.isEmpty(this.objFamilyBase) && !this.objFamilyBase.equals(X);
    }
}

