/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.core;

import scala.Function0;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scouter.io.DataOutputX;
import scouter.lang.pack.XLogPack;
import scouter.server.Configure;
import scouter.server.Logger$;
import scouter.server.core.CoreRun$;
import scouter.server.core.ServerStat;
import scouter.server.core.VisitorCore$;
import scouter.server.core.app.XLogGroupPerf$;
import scouter.server.core.app.XLogGroupUtil$;
import scouter.server.core.cache.XLogCache$;
import scouter.server.db.XLogWR$;
import scouter.server.geoip.GeoIpUtil$;
import scouter.server.plugin.PlugInManager;
import scouter.server.tagcnt.XLogTagCount$;
import scouter.server.util.ThreadScala$;
import scouter.util.RequestQueue;

public final class XLogCore$ {
    public static final XLogCore$ MODULE$;
    private final Configure conf;
    private final RequestQueue<XLogPack> queue;

    static {
        new XLogCore$();
    }

    public Configure conf() {
        return this.conf;
    }

    public RequestQueue<XLogPack> queue() {
        return this.queue;
    }

    public void calc(XLogPack m) {
        XLogGroupUtil$.MODULE$.process(m);
        if (this.conf().geoip_enabled) {
            GeoIpUtil$.MODULE$.setNationAndCity(m);
        }
        XLogGroupPerf$.MODULE$.add(m);
    }

    public void add(XLogPack p) {
        boolean ok;
        if (p.endTime == 0L) {
            p.endTime = System.currentTimeMillis();
        }
        if (!(ok = this.queue().put(p))) {
            Logger$.MODULE$.println("S116", 10, "queue exceeded!!");
        }
    }

    private XLogCore$() {
        MODULE$ = this;
        this.conf = Configure.getInstance();
        this.queue = new RequestQueue(this.conf().xlog_queue_size);
        ThreadScala$.MODULE$.startDaemon("scouter.server.core.XLogCore", (Function0<Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return CoreRun$.MODULE$.running();
            }
        }, (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                XLogPack m = XLogCore$.MODULE$.queue().get();
                ServerStat.put("xlog.core.queue", XLogCore$.MODULE$.queue().size());
                if (Configure.WORKABLE) {
                    byte by = m.xType;
                    switch (by) {
                        case 1: {
                            XLogCore$.MODULE$.calc(m);
                            break;
                        }
                        case 0: {
                            VisitorCore$.MODULE$.add(m);
                            XLogCore$.MODULE$.calc(m);
                        }
                    }
                    PlugInManager.xlog(m);
                    PlugInManager.xlogdb(m);
                    byte[] b = new DataOutputX().writePack(m).toByteArray();
                    XLogCache$.MODULE$.put(m.objHash, m.elapsed, m.error != 0, b);
                    if (XLogCore$.MODULE$.conf().tagcnt_enabled) {
                        XLogTagCount$.MODULE$.add(m);
                    }
                    XLogWR$.MODULE$.add(m.endTime, m.txid, m.gxid, m.elapsed, b);
                }
            }
        });
    }
}

