/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.core;

import java.util.List;
import java.util.function.Consumer;
import scala.Function0;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scouter.lang.pack.XLogDiscardTypes;
import scouter.lang.pack.XLogPack;
import scouter.lang.pack.XLogTypes;
import scouter.server.Configure;
import scouter.server.Logger$;
import scouter.server.core.CoreRun$;
import scouter.server.core.ProfilePreCore$;
import scouter.server.core.ServerStat;
import scouter.server.core.XLogCore$;
import scouter.server.core.cache.XLogDelayingCache;
import scouter.server.util.ThreadScala$;
import scouter.util.RequestQueue;

public final class XLogPreCore$ {
    public static final XLogPreCore$ MODULE$;
    private final Configure conf;
    private final RequestQueue<XLogPack> queue;

    static {
        new XLogPreCore$();
    }

    public Configure conf() {
        return this.conf;
    }

    public RequestQueue<XLogPack> queue() {
        return this.queue;
    }

    public void add(XLogPack pack) {
        boolean ok;
        if (pack.endTime == 0L) {
            pack.endTime = System.currentTimeMillis();
        }
        if (!(ok = this.queue().put(pack))) {
            Logger$.MODULE$.println("S116-0", 10, "queue exceeded!!");
        }
    }

    public void scouter$server$core$XLogPreCore$$processOnCondition(XLogPack pack) {
        if (pack.ignoreGlobalConsequentSampling) {
            if (XLogDiscardTypes.isAliveXLog(pack.discardType)) {
                this.process0(pack);
            }
        } else {
            this.process0(pack);
        }
    }

    private void process0(XLogPack pack) {
        XLogDelayingCache.instance.addProcessed(pack);
        this.processDelayingChildren(pack);
        XLogCore$.MODULE$.add(pack);
    }

    public boolean scouter$server$core$XLogPreCore$$canProcess(XLogPack pack) {
        return pack.isDriving() || pack.ignoreGlobalConsequentSampling || pack.discardType == 0 || XLogTypes.isService(pack.xType) && XLogDiscardTypes.isAliveXLog(pack.discardType) || XLogTypes.isZipkin(pack.xType) || XLogDelayingCache.instance.isProcessedGxid(pack.gxid);
    }

    private void processDelayingChildren(XLogPack pack) {
        ProfilePreCore$.MODULE$.addAsProcessDelayingChildren(pack);
        List<XLogPack> xLogList = XLogDelayingCache.instance.popDelayingChildren(pack);
        xLogList.forEach(new Consumer<XLogPack>(pack){
            private final XLogPack pack$1;

            public void accept(XLogPack delayingPack) {
                if (this.pack$1.discardType == 1) {
                    XLogCore$.MODULE$.add(delayingPack);
                }
            }
            {
                this.pack$1 = pack$1;
            }
        });
    }

    public void scouter$server$core$XLogPreCore$$waitOnMemory(XLogPack pack) {
        XLogDelayingCache.instance.addDelaying(pack);
    }

    private XLogPreCore$() {
        MODULE$ = this;
        this.conf = Configure.getInstance();
        this.queue = new RequestQueue(this.conf().xlog_queue_size);
        ThreadScala$.MODULE$.startDaemon("scouter.server.core.XLogPreCore", (Function0<Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return CoreRun$.MODULE$.running();
            }
        }, (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                XLogPack pack = XLogPreCore$.MODULE$.queue().get();
                ServerStat.put("xlog.core0.queue", XLogPreCore$.MODULE$.queue().size());
                if (Configure.WORKABLE) {
                    if (pack.isDropped()) {
                        XLogDelayingCache.instance.removeDelayingChildren(pack);
                        ProfilePreCore$.MODULE$.addAsDropped(pack);
                    } else if (XLogPreCore$.MODULE$.scouter$server$core$XLogPreCore$$canProcess(pack)) {
                        XLogPreCore$.MODULE$.scouter$server$core$XLogPreCore$$processOnCondition(pack);
                    } else {
                        XLogPreCore$.MODULE$.scouter$server$core$XLogPreCore$$waitOnMemory(pack);
                    }
                }
            }
        });
    }
}

