/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.core.app;

import scouter.server.core.app.MeterCounter;
import scouter.util.LinkedMap;

public class MeterCounterManager {
    private static MeterCounterManager instance = new MeterCounterManager();
    private LinkedMap<Key, MeterCounter> meterCounterMap = new LinkedMap().setMax(10000);

    public static MeterCounterManager getInstance() {
        return instance;
    }

    public MeterCounter getMeterCounter(int objHash, String counterName) {
        Key key = new Key(objHash, counterName);
        MeterCounter meterCounter = this.meterCounterMap.get(key);
        if (meterCounter == null) {
            meterCounter = new MeterCounter();
            this.meterCounterMap.put(key, meterCounter);
        }
        return meterCounter;
    }

    public static class Key {
        public int objHash;
        public String counterName;

        public Key(int objHash, String counterName) {
            this.objHash = objHash;
            this.counterName = counterName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key k = (Key)obj;
                return this.objHash == ((Key)obj).objHash && this.counterName.equals(((Key)obj).counterName);
            }
            return false;
        }

        public int hashCode() {
            return this.objHash ^ this.counterName.hashCode();
        }
    }
}

