/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db;

import java.io.File;
import scala.MatchError;
import scala.Tuple3;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.server.Logger$;
import scouter.server.db.DBCtr$;
import scouter.server.db.kv.KeyValueStoreIndex;
import scouter.server.db.kv.KeyValueStoreIndex$;
import scouter.server.db.kv.KeyValueStoreReader;
import scouter.server.db.kv.KeyValueStoreReader$;
import scouter.server.db.kv.KeyValueStoreWriter;
import scouter.server.db.kv.KeyValueStoreWriter$;
import scouter.util.StringUtil;

public final class KeyValueStoreRW$ {
    public static final KeyValueStoreRW$ MODULE$;

    static {
        new KeyValueStoreRW$();
    }

    public String get(String div, String key) {
        if (StringUtil.isEmpty(key) || StringUtil.isEmpty(div)) {
            Logger$.MODULE$.println("S223", 10, "illegal argument");
            return null;
        }
        Tuple3<KeyValueStoreIndex, KeyValueStoreWriter, KeyValueStoreReader> tuple3 = this.open(div);
        if (tuple3 != null) {
            Tuple3 tuple32;
            KeyValueStoreIndex indexDb = (KeyValueStoreIndex)tuple3._1();
            KeyValueStoreWriter dataWriter = (KeyValueStoreWriter)tuple3._2();
            KeyValueStoreReader dataReader = (KeyValueStoreReader)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)indexDb, (Object)dataWriter, (Object)dataReader);
            KeyValueStoreIndex indexDb2 = (KeyValueStoreIndex)tuple33._1();
            KeyValueStoreWriter dataWriter2 = (KeyValueStoreWriter)tuple33._2();
            KeyValueStoreReader dataReader2 = (KeyValueStoreReader)tuple33._3();
            if (indexDb2 == null || dataWriter2 == null || dataReader2 == null) {
                Logger$.MODULE$.println("S224", 10, "can't open kv db");
                return null;
            }
            long dataPos = indexDb2.get(key.getBytes("UTF-8"));
            if (dataPos == -1L) {
                return null;
            }
            byte[] bytes = dataReader2.read(dataPos);
            return new String(bytes, "UTF-8");
        }
        throw new MatchError(tuple3);
    }

    public boolean set(String div, String key, String text) {
        return this.set(div, key, text, -1L);
    }

    public boolean set(String div, String key, String text, long ttl) {
        if (StringUtil.isEmpty(text) || StringUtil.isEmpty(key) || StringUtil.isEmpty(div)) {
            Logger$.MODULE$.println("S222", 10, "illegal argument");
            return false;
        }
        Tuple3<KeyValueStoreIndex, KeyValueStoreWriter, KeyValueStoreReader> tuple3 = this.open(div);
        if (tuple3 != null) {
            Tuple3 tuple32;
            KeyValueStoreIndex indexDb = (KeyValueStoreIndex)tuple3._1();
            KeyValueStoreWriter dataWriter = (KeyValueStoreWriter)tuple3._2();
            KeyValueStoreReader dataReader = (KeyValueStoreReader)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)indexDb, (Object)dataWriter, (Object)dataReader);
            KeyValueStoreIndex indexDb2 = (KeyValueStoreIndex)tuple33._1();
            KeyValueStoreWriter dataWriter2 = (KeyValueStoreWriter)tuple33._2();
            KeyValueStoreReader dataReader2 = (KeyValueStoreReader)tuple33._3();
            if (indexDb2 == null || dataWriter2 == null) {
                Logger$.MODULE$.println("S221", 10, "can't open kv db");
                return false;
            }
            long dataPos = dataWriter2.write(text.getBytes("UTF8"));
            indexDb2.set(key.getBytes("UTF8"), dataPos, ttl);
            return true;
        }
        throw new MatchError(tuple3);
    }

    public boolean setTTL(String div, String key, long ttl) {
        if (StringUtil.isEmpty(key) || StringUtil.isEmpty(div)) {
            Logger$.MODULE$.println("S223", 10, "illegal argument");
            return false;
        }
        Tuple3<KeyValueStoreIndex, KeyValueStoreWriter, KeyValueStoreReader> tuple3 = this.open(div);
        if (tuple3 != null) {
            Tuple3 tuple32;
            KeyValueStoreIndex indexDb = (KeyValueStoreIndex)tuple3._1();
            KeyValueStoreWriter dataWriter = (KeyValueStoreWriter)tuple3._2();
            KeyValueStoreReader dataReader = (KeyValueStoreReader)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)indexDb, (Object)dataWriter, (Object)dataReader);
            KeyValueStoreIndex indexDb2 = (KeyValueStoreIndex)tuple33._1();
            KeyValueStoreWriter dataWriter2 = (KeyValueStoreWriter)tuple33._2();
            KeyValueStoreReader dataReader2 = (KeyValueStoreReader)tuple33._3();
            if (indexDb2 == null) {
                Logger$.MODULE$.println("S221", 10, "can't open kv db");
                return false;
            }
            indexDb2.setTTL(key.getBytes("UTF8"), ttl);
            return true;
        }
        throw new MatchError(tuple3);
    }

    public int delete(String div, String key) {
        if (StringUtil.isEmpty(key) || StringUtil.isEmpty(div)) {
            Logger$.MODULE$.println("S225", 10, "illegal argument");
            return -1;
        }
        Tuple3<KeyValueStoreIndex, KeyValueStoreWriter, KeyValueStoreReader> tuple3 = this.open(div);
        if (tuple3 != null) {
            Tuple3 tuple32;
            KeyValueStoreIndex indexDb = (KeyValueStoreIndex)tuple3._1();
            KeyValueStoreWriter dataWriter = (KeyValueStoreWriter)tuple3._2();
            KeyValueStoreReader dataReader = (KeyValueStoreReader)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)indexDb, (Object)dataWriter, (Object)dataReader);
            KeyValueStoreIndex indexDb2 = (KeyValueStoreIndex)tuple33._1();
            KeyValueStoreWriter dataWriter2 = (KeyValueStoreWriter)tuple33._2();
            KeyValueStoreReader dataReader2 = (KeyValueStoreReader)tuple33._3();
            if (indexDb2 == null) {
                Logger$.MODULE$.println("S226", 10, "can't open kv db");
                return -1;
            }
            return indexDb2.delete(key.getBytes("UTF8"));
        }
        throw new MatchError(tuple3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple3<KeyValueStoreIndex, KeyValueStoreWriter, KeyValueStoreReader> open(String div) {
        KeyValueStoreIndex indexDb = null;
        KeyValueStoreWriter dataWriter = null;
        KeyValueStoreReader dataReader = null;
        try {
            indexDb = KeyValueStoreIndex$.MODULE$.get(div);
            dataWriter = KeyValueStoreWriter$.MODULE$.get(div);
            dataReader = KeyValueStoreReader$.MODULE$.get(div);
            if (indexDb != null && dataWriter != null && dataReader != null) return new Tuple3((Object)indexDb, (Object)dataWriter, (Object)dataReader);
            KeyValueStoreRW$ keyValueStoreRW$ = this;
            synchronized (keyValueStoreRW$) {
                String path = this.getDBPath();
                File f = new File(path);
                Object object = !f.exists() ? BoxesRunTime.boxToBoolean((boolean)f.mkdirs()) : BoxedUnit.UNIT;
                String file = new StringBuilder().append((Object)path).append((Object)"/kv_").append((Object)div).toString();
                indexDb = KeyValueStoreIndex$.MODULE$.open(div, file);
                dataWriter = KeyValueStoreWriter$.MODULE$.open(div, file);
                dataReader = KeyValueStoreReader$.MODULE$.open(div, file);
                return new Tuple3((Object)indexDb, (Object)dataWriter, (Object)dataReader);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            indexDb.close();
            dataWriter.close();
            dataReader.close();
            return new Tuple3(null, null, null);
        }
    }

    public String getDBPath() {
        StringBuffer sb = new StringBuffer();
        sb.append(DBCtr$.MODULE$.getRootPath());
        sb.append("/00000000/kv2");
        return sb.toString();
    }

    private KeyValueStoreRW$() {
        MODULE$ = this;
    }
}

