/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.server.Logger$;
import scouter.server.core.CoreRun$;
import scouter.server.core.ServerStat;
import scouter.server.core.cache.TextCache$;
import scouter.server.db.DBCtr$;
import scouter.server.db.TextDupCheck;
import scouter.server.db.TextPermWR$;
import scouter.server.db.TextWR;
import scouter.server.db.text.TextTable;
import scouter.server.db.text.TextTable$;
import scouter.server.util.EnumerScala$;
import scouter.server.util.ThreadScala$;
import scouter.util.FileUtil;
import scouter.util.IClose;
import scouter.util.LinkedMap;
import scouter.util.RequestQueue;

public final class TextWR$ {
    public static final TextWR$ MODULE$;
    private final LinkedMap<String, TextTable> database;
    private ArrayList<String> idleConns;
    private final RequestQueue<TextWR.Data> queue;

    static {
        new TextWR$();
    }

    public LinkedMap<String, TextTable> database() {
        return this.database;
    }

    public ArrayList<String> idleConns() {
        return this.idleConns;
    }

    public void idleConns_$eq(ArrayList<String> x$1) {
        this.idleConns = x$1;
    }

    public RequestQueue<TextWR.Data> queue() {
        return this.queue;
    }

    public void closeIdle() {
        if (this.idleConns().size() == 0) {
            return;
        }
        ArrayList<String> x = this.idleConns();
        this.idleConns_$eq(new ArrayList<String>());
        EnumerScala$.MODULE$.foreach(x.iterator(), new Serializable(){
            public static final long serialVersionUID = 0L;

            public final IClose apply(String id) {
                return FileUtil.close(TextWR$.MODULE$.database().remove(id));
            }
        });
    }

    public TextTable getTable(String date) {
        TextTable table = this.database().get(date);
        if (table != null) {
            table.setActive(System.currentTimeMillis());
        }
        return table;
    }

    public void putTable(String date, TextTable table) {
        this.database().put(date, table);
    }

    public void process(TextWR.Data data) {
        if (TextPermWR$.MODULE$.isA(data.div())) {
            TextDupCheck.addDuplicated(data.div(), data.textUnit());
            TextPermWR$.MODULE$.add(data.div(), data.hash(), data.text());
        } else {
            TextTable textTable = this.open(data.date());
            if (textTable == null) {
                this.queue().clear();
                Logger$.MODULE$.println("S139", 10, "can't open db");
            } else {
                boolean ok = textTable.hasKey(data.div(), data.hash());
                if (!ok) {
                    TextDupCheck.addDuplicated(data.div(), data.textUnit());
                    textTable.set(data.div(), data.hash(), data.text().getBytes("UTF8"));
                }
            }
        }
    }

    public void add(String date, String div, int hash, String text) {
        TextCache$.MODULE$.put(div, hash, text);
        TextDupCheck.TextUnit tu = new TextDupCheck.TextUnit(date, hash);
        if (TextDupCheck.isDuplicated(div, tu)) {
            return;
        }
        boolean ok = this.queue().put(new TextWR.Data(date, div, hash, text, tu));
        if (!ok) {
            Logger$.MODULE$.println("S140", 10, "queue exceeded!!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TextTable open(String date) {
        TextTable textTable = this.getTable(date);
        if (textTable != null) return textTable;
        TextWR$ textWR$ = this;
        synchronized (textWR$) {
            try {
                textTable = this.getTable(date);
                if (textTable == null) {
                    String dbDirByDate = this.getDBPath(date);
                    File f = new File(dbDirByDate);
                    Object object = !f.exists() ? BoxesRunTime.boxToBoolean((boolean)f.mkdirs()) : BoxedUnit.UNIT;
                    String textFilePath = new StringBuilder().append((Object)dbDirByDate).append((Object)"/text").toString();
                    textTable = TextTable$.MODULE$.open(textFilePath);
                    this.putTable(date, textTable);
                    return textTable;
                }
                return textTable;
            }
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable2.printStackTrace();
                    this.close();
                    return null;
                }
            }
        }
    }

    public String getDBPath(String date) {
        StringBuffer sb = new StringBuffer();
        sb.append(DBCtr$.MODULE$.getRootPath());
        sb.append(new StringBuilder().append((Object)"/").append((Object)date).append((Object)"/text").toString());
        return sb.toString();
    }

    public void close() {
        LinkedMap<String, TextTable> linkedMap = this.database();
        synchronized (linkedMap) {
            while (this.database().size() > 0) {
                this.database().removeFirst().close();
            }
            return;
        }
    }

    private TextWR$() {
        MODULE$ = this;
        this.database = new LinkedMap();
        this.idleConns = new ArrayList();
        this.queue = new RequestQueue(DBCtr$.MODULE$.LARGE_MAX_QUE_SIZE());
        ThreadScala$.MODULE$.start("scouter.server.db.TextWR", (Function0<Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return CoreRun$.MODULE$.running();
            }
        }, 10000L, (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                long now = System.currentTimeMillis();
                Enumeration<String> en = TextWR$.MODULE$.database().keys();
                while (en.hasMoreElements()) {
                    String key = en.nextElement();
                    TextTable db = TextWR$.MODULE$.database().get(key);
                    Object object = db == null ? BoxedUnit.UNIT : (now - db.getLastActive() > 300000L ? BoxesRunTime.boxToBoolean((boolean)TextWR$.MODULE$.idleConns().add(key)) : BoxedUnit.UNIT);
                }
            }
        });
        ThreadScala$.MODULE$.start("scouter.server.db.TextWR-2", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void apply$mcV$sp() {
                while (true) {
                    if (!DBCtr$.MODULE$.running()) {
                        TextWR$.MODULE$.close();
                        return;
                    }
                    TextWR$.MODULE$.closeIdle();
                    TextWR.Data data = TextWR$.MODULE$.queue().get(10000L);
                    ServerStat.put("text.db.queue", TextWR$.MODULE$.queue().size());
                    if (data == null) continue;
                    try {
                        TextWR$.MODULE$.process(data);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
    }
}

