/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db;

import java.io.File;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.ListValue;
import scouter.server.db.DBCtr$;
import scouter.server.util.EnumerScala$;
import scouter.server.util.ThreadScala$;
import scouter.server.util.cardinality.HyperLogLog;
import scouter.util.DateUtil;
import scouter.util.FileUtil;
import scouter.util.Hexa32;
import scouter.util.IntKeyLinkedMap;
import scouter.util.StringKeyLinkedMap;
import scouter.util.ThreadUtil;

public final class VisitorDB$ {
    public static final VisitorDB$ MODULE$;
    private final int rsd;
    private long lastFlush;
    private final IntKeyLinkedMap<HyperLogLog> objHashHyperTable;
    private final StringKeyLinkedMap<HyperLogLog> objTypeHyperTable;

    static {
        new VisitorDB$();
    }

    public int rsd() {
        return this.rsd;
    }

    private long lastFlush() {
        return this.lastFlush;
    }

    private void lastFlush_$eq(long x$1) {
        this.lastFlush = x$1;
    }

    public void scouter$server$db$VisitorDB$$flush() {
        long now = System.currentTimeMillis();
        if (now - this.lastFlush() >= 10000L) {
            this.lastFlush_$eq(now);
            EnumerScala$.MODULE$.foreach(this.objHashHyperTable().keys(), (Function1<Object, Object>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(int h) {
                    this.apply$mcVI$sp(h);
                }

                public void apply$mcVI$sp(int h) {
                    try {
                        HyperLogLog hhl = VisitorDB$.MODULE$.objHashHyperTable().get(h);
                        if (hhl != null && hhl.dirty) {
                            hhl.dirty = false;
                            VisitorDB$.MODULE$.scouter$server$db$VisitorDB$$save(Hexa32.toString32(h), hhl);
                        }
                    }
                    catch (Throwable throwable) {}
                }
            });
            EnumerScala$.MODULE$.foreach(this.objTypeHyperTable().keys(), (Function1<String, Object>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String o) {
                    try {
                        HyperLogLog hhl = VisitorDB$.MODULE$.objTypeHyperTable().get(o);
                        if (hhl != null && hhl.dirty) {
                            hhl.dirty = false;
                            VisitorDB$.MODULE$.scouter$server$db$VisitorDB$$save(o, hhl);
                        }
                    }
                    catch (Throwable throwable) {}
                }
            });
        }
    }

    public IntKeyLinkedMap<HyperLogLog> objHashHyperTable() {
        return this.objHashHyperTable;
    }

    public StringKeyLinkedMap<HyperLogLog> objTypeHyperTable() {
        return this.objTypeHyperTable;
    }

    public HyperLogLog getNewObjType(String objType2) {
        Object object;
        HyperLogLog h = this.objTypeHyperTable().get(objType2);
        if (h == null) {
            h = this.scouter$server$db$VisitorDB$$load(DateUtil.yyyymmdd(), objType2);
            if (h == null) {
                h = new HyperLogLog(this.rsd());
            }
            object = this.objTypeHyperTable().put(objType2, h);
        } else {
            object = BoxedUnit.UNIT;
        }
        h.dirty = true;
        return h;
    }

    public HyperLogLog getNewObject(int objHash) {
        Object object;
        HyperLogLog h = this.objHashHyperTable().get(objHash);
        if (h == null) {
            h = this.scouter$server$db$VisitorDB$$load(DateUtil.yyyymmdd(), Hexa32.toString32(objHash));
            if (h == null) {
                h = new HyperLogLog(this.rsd());
            }
            object = this.objHashHyperTable().put(objHash, h);
        } else {
            object = BoxedUnit.UNIT;
        }
        h.dirty = true;
        return h;
    }

    public HyperLogLog scouter$server$db$VisitorDB$$load(String date, String name) {
        HyperLogLog hyperLogLog;
        String path = this.getDBPath(date);
        File f = new File(path);
        Object object = !f.exists() ? BoxesRunTime.boxToBoolean((boolean)f.mkdirs()) : BoxedUnit.UNIT;
        File file = new File(new StringBuilder().append((Object)path).append((Object)"/").append((Object)name).append((Object)".usr").toString());
        if (file.exists()) {
            byte[] bytes = FileUtil.readAll(file);
            hyperLogLog = HyperLogLog.build(bytes);
        } else {
            hyperLogLog = null;
        }
        return hyperLogLog;
    }

    public void scouter$server$db$VisitorDB$$save(String name, HyperLogLog hll) {
        String path = this.getDBPath(DateUtil.yyyymmdd());
        File f = new File(path);
        Object object = !f.exists() ? BoxesRunTime.boxToBoolean((boolean)f.mkdirs()) : BoxedUnit.UNIT;
        File file = new File(new StringBuilder().append((Object)path).append((Object)"/").append((Object)name).append((Object)".usr").toString());
        FileUtil.save(file, hll.getBytes());
    }

    private String getDBPath(String date) {
        StringBuffer sb = new StringBuffer();
        sb.append(DBCtr$.MODULE$.getRootPath());
        sb.append("/").append(date).append("/visit");
        return sb.toString();
    }

    public long getVisitorObjType(String objType2) {
        HyperLogLog h = this.objTypeHyperTable().get(objType2);
        if (h == null) {
            h = this.scouter$server$db$VisitorDB$$load(DateUtil.yyyymmdd(), objType2);
        }
        return h == null ? 0L : h.cardinality();
    }

    public long getVisitorObjType(String date, String objType2) {
        HyperLogLog h = this.scouter$server$db$VisitorDB$$load(date, objType2);
        return h == null ? 0L : h.cardinality();
    }

    public long getVisitorObject(int objHash) {
        HyperLogLog h = this.objHashHyperTable().get(objHash);
        if (h == null) {
            h = this.scouter$server$db$VisitorDB$$load(DateUtil.yyyymmdd(), Hexa32.toString32(objHash));
        }
        return h == null ? 0L : h.cardinality();
    }

    public long getVisitorObject(String date, int objHash) {
        HyperLogLog h = this.scouter$server$db$VisitorDB$$load(date, Hexa32.toString32(objHash));
        return h == null ? 0L : h.cardinality();
    }

    public long getMergedVisitorObject(ListValue objHashLv) {
        HyperLogLog totalVisitor = new HyperLogLog(this.rsd());
        EnumerScala$.MODULE$.foreach(objHashLv, new Serializable(totalVisitor){
            public static final long serialVersionUID = 0L;
            private final HyperLogLog totalVisitor$1;

            public final void apply(DecimalValue obj) {
                HyperLogLog h = VisitorDB$.MODULE$.objHashHyperTable().get(obj.intValue());
                if (h == null) {
                    h = VisitorDB$.MODULE$.scouter$server$db$VisitorDB$$load(DateUtil.yyyymmdd(), Hexa32.toString32(obj.intValue()));
                }
                if (h != null) {
                    this.totalVisitor$1.addAll(h);
                }
            }
            {
                this.totalVisitor$1 = totalVisitor$1;
            }
        });
        return totalVisitor.cardinality();
    }

    public long getMergedVisitorObject(String date, ListValue objHashLv) {
        HyperLogLog totalVisitor = new HyperLogLog(this.rsd());
        EnumerScala$.MODULE$.foreach(objHashLv, new Serializable(date, totalVisitor){
            public static final long serialVersionUID = 0L;
            private final String date$1;
            private final HyperLogLog totalVisitor$2;

            public final void apply(DecimalValue obj) {
                HyperLogLog h = VisitorDB$.MODULE$.scouter$server$db$VisitorDB$$load(this.date$1, Hexa32.toString32(obj.intValue()));
                if (h != null) {
                    this.totalVisitor$2.addAll(h);
                }
            }
            {
                this.date$1 = date$1;
                this.totalVisitor$2 = totalVisitor$2;
            }
        });
        return totalVisitor.cardinality();
    }

    private VisitorDB$() {
        MODULE$ = this;
        this.rsd = 20;
        ThreadScala$.MODULE$.startDaemon("scouter.server.db.VisitorDB", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                long dateUnit = DateUtil.getDateUnit();
                while (DBCtr$.MODULE$.running()) {
                    if (dateUnit != DateUtil.getDateUnit()) {
                        dateUnit = DateUtil.getDateUnit();
                        VisitorDB$.MODULE$.objTypeHyperTable().clear();
                        VisitorDB$.MODULE$.objHashHyperTable().clear();
                    }
                    VisitorDB$.MODULE$.scouter$server$db$VisitorDB$$flush();
                    ThreadUtil.sleep(1000L);
                }
            }
        });
        this.lastFlush = System.currentTimeMillis();
        this.objHashHyperTable = new IntKeyLinkedMap().setMax(500);
        this.objTypeHyperTable = new StringKeyLinkedMap().setMax(100);
    }
}

