/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db;

import java.io.File;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.server.Configure;
import scouter.server.Logger$;
import scouter.server.core.ServerStat;
import scouter.server.db.DBCtr$;
import scouter.server.db.XLogWR;
import scouter.server.db.xlog.XLogDataWriter;
import scouter.server.db.xlog.XLogDataWriter$;
import scouter.server.db.xlog.XLogIndex;
import scouter.server.db.xlog.XLogIndex$;
import scouter.server.util.OftenAction$;
import scouter.server.util.ThreadScala$;
import scouter.util.DateUtil;
import scouter.util.FileUtil;
import scouter.util.IClose;
import scouter.util.RequestQueue;
import scouter.util.ThreadUtil;

public final class XLogWR$ {
    public static final XLogWR$ MODULE$;
    private final long MAX_IDLE;
    private final String dir;
    private final String prefix;
    private final RequestQueue<XLogWR.XLogData> queue;
    private final Map<Object, XLogWR.StorageContainer> dailyContainer;

    static {
        new XLogWR$();
    }

    public long MAX_IDLE() {
        return this.MAX_IDLE;
    }

    public String dir() {
        return this.dir;
    }

    public String prefix() {
        return this.prefix;
    }

    public RequestQueue<XLogWR.XLogData> queue() {
        return this.queue;
    }

    public Map<Object, XLogWR.StorageContainer> dailyContainer() {
        return this.dailyContainer;
    }

    public void add(long time, long tid, long gid, int elapsed, byte[] data) {
        boolean ok = this.queue().put(new XLogWR.XLogData(time, tid, gid, elapsed, data));
        if (!ok) {
            Logger$.MODULE$.println("S144", 10, "queue exceeded!!");
        }
    }

    public void closeAll() {
        this.dailyContainer().values().foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final IClose apply(XLogWR.StorageContainer container) {
                FileUtil.close(container.index());
                return FileUtil.close(container.writer());
            }
        });
        this.dailyContainer().clear();
    }

    public void close(long time) {
        this.dailyContainer().get((Object)BoxesRunTime.boxToLong((long)time)).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final IClose apply(XLogWR.StorageContainer container) {
                FileUtil.close(container.index());
                return FileUtil.close(container.writer());
            }
        });
        this.dailyContainer().remove((Object)BoxesRunTime.boxToLong((long)time));
    }

    public Tuple2<XLogIndex, XLogDataWriter> open(long time) {
        String date = DateUtil.yyyymmdd(time);
        try {
            String path = this.getDBPath(date);
            File f = new File(path);
            Object object = f.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)f.mkdirs());
            String file = new StringBuilder().append((Object)path).append((Object)"/").append((Object)this.prefix()).toString();
            XLogIndex index = XLogIndex$.MODULE$.open(file);
            XLogDataWriter writer = XLogDataWriter$.MODULE$.open(date, file);
            return new Tuple2((Object)index, (Object)writer);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.close(time);
            return new Tuple2(null, null);
        }
    }

    public String getDBPath(String date) {
        StringBuffer sb = new StringBuffer();
        sb.append(DBCtr$.MODULE$.getRootPath());
        sb.append("/").append(date).append(this.dir());
        return sb.toString();
    }

    private XLogWR$() {
        MODULE$ = this;
        this.MAX_IDLE = 1800000L;
        this.dir = "/xlog";
        this.prefix = "xlog";
        this.queue = new RequestQueue(Configure.getInstance().xlog_queue_size);
        this.dailyContainer = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ThreadScala$.MODULE$.start("scouter.server.db.XLogDataFileWatcher", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                while (DBCtr$.MODULE$.running()) {
                    ThreadUtil.sleep(300000L);
                    long now = System.currentTimeMillis();
                    ((MapLike)XLogWR$.MODULE$.dailyContainer().filter((Function1)new Serializable(this, now){
                        public static final long serialVersionUID = 0L;
                        private final long now$1;

                        public final boolean apply(Tuple2<Object, XLogWR.StorageContainer> kv) {
                            return this.now$1 - ((XLogWR.StorageContainer)kv._2()).lastAccess() > ((XLogWR.StorageContainer)kv._2()).idleLimit();
                        }
                        {
                            this.now$1 = now$1;
                        }
                    })).keys().foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(long k) {
                            this.apply$mcVJ$sp(k);
                        }

                        public void apply$mcVJ$sp(long k) {
                            XLogWR$.MODULE$.close(k);
                        }
                    });
                }
            }
        });
        ThreadScala$.MODULE$.start("scouter.server.db.XLogWR", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void apply$mcV$sp() {
                while (true) {
                    XLogWR.StorageContainer container;
                    XLogWR.XLogData m;
                    block5: {
                        if (!DBCtr$.MODULE$.running()) {
                            XLogWR$.MODULE$.closeAll();
                            return;
                        }
                        m = XLogWR$.MODULE$.queue().get();
                        ServerStat.put("xlog.db.queue", XLogWR$.MODULE$.queue().size());
                        try {
                            long currentDateUnit = DateUtil.getDateUnit(m.time());
                            container = (XLogWR.StorageContainer)XLogWR$.MODULE$.dailyContainer().getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)currentDateUnit), (Function0)new Serializable(this, m){
                                public static final long serialVersionUID = 0L;
                                private final XLogWR.XLogData m$1;

                                public final XLogWR.StorageContainer apply() {
                                    Tuple2<XLogIndex, XLogDataWriter> tuple2 = XLogWR$.MODULE$.open(this.m$1.time());
                                    if (tuple2 != null) {
                                        Tuple2 tuple22;
                                        XLogIndex index = (XLogIndex)tuple2._1();
                                        XLogDataWriter writer = (XLogDataWriter)tuple2._2();
                                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)index, (Object)writer);
                                        XLogIndex index2 = (XLogIndex)tuple23._1();
                                        XLogDataWriter writer2 = (XLogDataWriter)tuple23._2();
                                        return new XLogWR.StorageContainer(XLogWR$.MODULE$.MAX_IDLE(), System.currentTimeMillis(), index2, writer2);
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    this.m$1 = m$1;
                                }
                            });
                            if (container.index() == null) {
                                OftenAction$.MODULE$.act("XLoWR", 10, (Function0<BoxedUnit>)new Serializable(this, currentDateUnit){
                                    public static final long serialVersionUID = 0L;
                                    private final long currentDateUnit$1;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        XLogWR$.MODULE$.dailyContainer().remove((Object)BoxesRunTime.boxToLong((long)this.currentDateUnit$1));
                                        XLogWR$.MODULE$.queue().clear();
                                    }
                                    {
                                        this.currentDateUnit$1 = currentDateUnit$1;
                                    }
                                });
                                Logger$.MODULE$.println("SZ143", 10, "can't open XLoWR");
                            }
                            break block5;
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                        continue;
                    }
                    container.lastAccess_$eq(System.currentTimeMillis());
                    long location = container.writer().write(m.data());
                    container.index().setByTime(m.time(), location);
                    container.index().setByTxid(m.txid(), location);
                    container.index().setByGxid(m.gxid(), location);
                }
            }
        });
    }
}

